package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.PersonQualifications;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskRiskControlPrePerson;
import com.yeejoin.precontrol.common.mapper.TaskRiskControlPrePersonMapper;
import com.yeejoin.precontrol.common.service.IPersonAscriptionService;
import com.yeejoin.precontrol.common.service.IPersonQualificationsService;
import com.yeejoin.precontrol.common.service.ITaskPersonService;
import com.yeejoin.precontrol.common.service.ITaskRiskControlPrePersonService;
import com.yeejoin.precontrol.common.vo.TaskRiskControlPrePersonVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 风险管控预选人员表 服务实现类
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Service
public class TaskRiskControlPrePersonServiceImpl
		extends ServiceImpl<TaskRiskControlPrePersonMapper, TaskRiskControlPrePerson>
		implements ITaskRiskControlPrePersonService {

	@Autowired
	ITaskPersonService iTaskPersonService;

	@Autowired
	IPersonAscriptionService iPersonAscriptionService;

	@Autowired
	IPersonQualificationsService iPersonQualificationsService;

	@Override
	public List<TaskRiskControlPrePersonVo> listVo(TaskRiskControlPrePerson taskRiskControlPrePerson) {
		List<TaskRiskControlPrePersonVo> list = this.baseMapper.listVo(taskRiskControlPrePerson);
		list.forEach(i -> {
			TaskPerson taskPerson = iTaskPersonService.getOne(
					new LambdaQueryWrapper<TaskPerson>().eq(TaskPerson::getTaskId, taskRiskControlPrePerson.getTaskId())
							.eq(TaskPerson::getPersonId, i.getPersonId()));
			PersonAscription personAscription = iPersonAscriptionService.getOne(
					new LambdaQueryWrapper<PersonAscription>().eq(PersonAscription::getPersonId, i.getPersonId()));
			List<PersonQualifications> personQualifications = iPersonQualificationsService
					.list(new LambdaQueryWrapper<PersonQualifications>().eq(PersonQualifications::getPersonId,
							i.getPersonId()));
			List<String> certificate = Lists.transform(personQualifications,
					PersonQualifications::getCertificateNameKey);
			certificate = certificate.stream().filter(Objects::nonNull).collect(Collectors.toList());
			if (taskPerson != null) {
				i.setTaskExamStatus(taskPerson.getExamStatus());
				i.setTaskKnowledgeStatus(taskPerson.getKnowledgeStatus());
			}
			if (personAscription != null) {
				i.setPostName(personAscription.getPostName());
			}
			i.setCertificate(certificate);
		});
		return list;
	}
}
