package com.yeejoin.precontrol.common.start;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.IdPasswordAuthModel;
import com.yeejoin.precontrol.common.utils.DesUtil;
import com.yeejoin.precontrol.common.utils.RedisUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.Map;

@Service
public class StartPlatformTokenService {

	@Value("${admin.product}")
	String product;

	@Value("${admin.appkey}")
	String appkey;

	@Value("${admin.user}")
	String user;

	@Value("${admin.password}")
	String password;

	@Value("${amos.secret.key}")
	String secretKey;

	@Autowired
	RedisUtil redisUtil;

	public void getToken() {
		RequestContext.setProduct(product);
		RequestContext.setAppKey(appkey);
		IdPasswordAuthModel authModel = new IdPasswordAuthModel();
		authModel.setLoginId(user);
		authModel.setPassword(DesUtil.encode(password, secretKey));
		System.out.println("user:" + user);
		System.out.println("secretKey:" + secretKey);
		System.out.println("================================startPlatform");
		FeignClientResult<Map<String, String>> authResult = Privilege.authClient.idpassword(authModel);
		String token = authResult.getResult().get("token");
		System.out.println("token:" + token);
		RequestContext.setToken(token);
		redisUtil.set("platform_token", token);
	}
}
