package com.yeejoin.precontrol.common.vo;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class BadManagementVo {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "主键ID")
    private Long id;
    @ApiModelProperty(value = "违规内容")
    private String body;
    @ApiModelProperty(value = "任务ID")
    private Long taskId;
    @ApiModelProperty(value = "分包商企业ID")
    private Long companyId;
    @ApiModelProperty(value = "分包商责任人")
    private Long personLiable;
    @ApiModelProperty(value = "违章时间")
    private String createDate;
    @ApiModelProperty(value = "违规类型")
    private String type;
    @ApiModelProperty(value = "违章性质")
    private String nature;
    @ApiModelProperty(value = "是否失效（判断红码统计）")
    private boolean notValid;
    @ApiModelProperty(value = "违章照片")
    @ImagePrefix
    private String filePath;
    @ApiModelProperty(value = "违章照片")
    @ImagePrefix
    private List<String> filesPath;
    @ApiModelProperty(value = "项目名称")
    private String projectName;
}
