package com.yeejoin.precontrol.common.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.TaskPerson;
import com.yeejoin.precontrol.common.entity.TaskRiskWorkMeasureResult;
import com.yeejoin.precontrol.common.param.RiskWorkParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 风险管控任务表Vo
 *
 * @author duanwei
 * @date 2021-01-28
 */
@Data
public class TaskRiskControlVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "id")
	private Long id;

	@ApiModelProperty(value = "风险管控名称")
	/**
	 * 风险管控名称
	 */
	private String name;
	@ApiModelProperty(value = "项目id")
	/**
	 * 项目id
	 */
	private Long projectId;

	@ApiModelProperty(value = "风险作业id")
	/**
	 * 风险作业id
	 */
	private Long riskWorkId;
	@ApiModelProperty(value = "计划开始时间")
	/**
	 * 计划开始时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date startTime;
	@ApiModelProperty(value = "计划结束时间")
	/**
	 * 计划结束时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date endTime;
	@ApiModelProperty(value = "提前启动时间")
	/**
	 * 提前启动时间
	 */
	private Integer preStartTime;
	@ApiModelProperty(value = "任务id")
	/**
	 * 任务id
	 */
	private Long taskId;
	@ApiModelProperty(value = "阶段")
	/**
	 * 阶段
	 */
	private Integer stage;
	@ApiModelProperty(value = "公司id")
	/**
	 * 公司id
	 */
	private Long companyId;
	/**
	 * 公司名称
	 */
	private String companyName;
	@ApiModelProperty(value = "公司负责人id")
	/**
	 * 公司负责人id
	 */
	private Long companyPersonId;

	/**
	 * 公司负责人name
	 */
	private String companyPersonName;

	/**
	 * 项目名称
	 */
	private String projectName;

	@ApiModelProperty(value = "安全负责人id")
	private Long secPersonId;

	/**
	 * 用户名称
	 */
	private String secPersonName;

	/**
	 * 状态
	 */
	private String status;

	/**
	 * 状态code
	 */
	private String statusCode;

	@ApiModelProperty(value = "预选专业人员列表")
	private List<TaskRiskControlPrePersonVo> preProPersonList;

	@ApiModelProperty(value = "预选辅助人员列表")
	private List<TaskRiskControlPrePersonVo> preAssistPersonList;

	@ApiModelProperty(value = "考试模板id")
	private Long examTemplateId;

	@ApiModelProperty(value = "考试id")
	private Long examId;

	@ApiModelProperty(value = "考试模板名称")
	private String examTemplateName;

	@ApiModelProperty(value = "考试人员列表")
	private List<TaskPerson> examPersonList;

	@ApiModelProperty(value = "技术库id")
	private Long knowledgeDocumentId;

	@ApiModelProperty(value = "技术库名称")
	private String knowledgeDocumentName;

	@ApiModelProperty(value = "技术库分类id")
	private Long knowledgeCategoryId;

	@ApiModelProperty(value = "知识人员列表")
	private List<TaskPerson> knowledgePersonList;

	@ApiModelProperty(value = "是否考试")
	private Boolean isExam;

	@ApiModelProperty(value = "是否知识")
	private Boolean isKnowledge;

	@ApiModelProperty(value = "项目部技术员")
	private List<TaskPerson> techPersonList;

	@ApiModelProperty(value = "项目部安全员")
	private List<TaskPerson> secPersonList;

	@ApiModelProperty(value = "风险作业检查项列表")
	private List<HazardousWorkVo> hazardWorkList;

	@ImagePrefix
	@ApiModelProperty(value = "新照片")
	private List<TaskPersonAndImageInfo> newImageList;
	
	@ImagePrefix
	@ApiModelProperty(value = "照片")
	private List<TaskPersonAndImageInfo> imageList;

	@ApiModelProperty(value = "人员评价")
	private List<UserEvaluationLogVo> userEvaList;

	@ApiModelProperty(value = "分包商评价")
	private List<CompanyEvaluationLogVo> companyEvaList;

	@ApiModelProperty(value = "任务人员id")
	private Long taskPersonId;

	@ApiModelProperty(value = "任务人员类型")
	private Long taskPersonType;

	@ApiModelProperty(value = "任务人员考试状态")
	private Integer taskPersonExamStatus;

	@ApiModelProperty(value = "任务人员知识状态")
	private Integer taskPersonKnowledgeStatus;

	@ApiModelProperty(value = "任务人员考试id")
	private Long taskPersonExamId;

	@ApiModelProperty(value = "任务人员考试id")
	private Long taskPersonKnowledgeId;
	
	@ApiModelProperty(value = "任务人员考试截止时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskPersonExpireDate;
	
	@ApiModelProperty(value = "风险作业名称")
	private String riskWorkName;

	@ApiModelProperty(value = "任务人员阅读状态")
	private Long readStatus;

	@ApiModelProperty(value = "组织机构code")
	private String orgCode;

	@ApiModelProperty(value = "超期")
	private String limitDateDesc;

	@ApiModelProperty(value = "项目地址")
	private String projectAddress;

	@ApiModelProperty(value = "风险作业")
	private RiskWorkParam riskWork;

	@ApiModelProperty(value = "是否开启")
	private Boolean isStart;

	@ApiModelProperty(value = "检查措施")
	private List<TaskRiskWorkMeasureResult> measureResultList;
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = " 实际开始时间")
	private Date taskStartTime;
	
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ApiModelProperty(value = "实际结束时间")
	private Date taskEndTime;
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	@ApiModelProperty(value = "超时时间")
	private Date expireDate;
	
	@ApiModelProperty(value = "发起人id")
	private Long createPersonId;
	
	@ApiModelProperty(value = "发起人姓名")
	private String createPersonName;
	
	@ApiModelProperty(value = "安全员taskperson")
	private TaskPerson secTaskPerson;
	
	@ApiModelProperty(value = "风险等级")
	private Integer level;
	@ApiModelProperty(value = "任务编号")
	private Long taskNo;
	   
    @ApiModelProperty(value = "技术负责人id")
    private Long techPersonId;
    
    @ApiModelProperty(value = "施工方案id")
    private Long constructDocumentId;
	
	private TaskRiskControlTechVo riskControlTechVo;
	
	private String taskPersonRoleType;
	
	private String taskPersonRoleTypeName;
}