package com.yeejoin.amos.supervision.common.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum CheckItemFinishStatusEnum {

    TIME_DESC("未执行", "0"),
    TIME_ASC("已执行", "1");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    CheckItemFinishStatusEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(CheckItemFinishStatusEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put("name", e.getName());
            map.put("value", e.getCode());
            return map;
        }).collect(Collectors.toList());
    }

    public static String getName(String value) {
        for (CheckItemFinishStatusEnum c : CheckItemFinishStatusEnum.values()) {
            if (c.getCode().equals(value)) {
                return c.name;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
