package com.yeejoin.amos.supervision.dao.entity;

import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

/**
 * @author keyong
 * @title: LatentDangerPhoto
 * <pre>
 * @description: 隐患图片
 * </pre>
 * @date 2021/1/26 14:50
 */
@Entity
@Table(name = "p_latent_danger_photo")
@NamedQuery(name = "LatentDangerPhoto.findAll", query = "SELECT c FROM LatentDangerPhoto c")
@Where(clause = "deleted=0") //表示未删除的数据
@Data
public class LatentDangerPhoto extends BasicEntity {
    private static final long serialVersionUID = 1L;

    @Column(name = "biz_code")
    private String bizCode;

    @Column(name = "url")
    private String url;

    @Column(name = "biz_id")
    private Long bizId;

    @Column(name = "deleted")
    private String deleted;

    @Column(name = "update_date")
    private String updateDate;
}
