package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireRiskSourceServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * 风险点表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "风险点表Api")
@RequestMapping(value = "/fire-risk-source")
public class FireRiskSourceController extends BaseController {

    @Autowired
    FireRiskSourceServiceImpl fireRiskSourceServiceImpl;


    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "查询风险点RPN统计", notes = "查询风险点RPN统计")
    @GetMapping(value = "/{stationCode}/list")
    public ResponseModel selectForRpnTopList(
            @ApiParam(value = "换流站code", required = true) @PathVariable String stationCode,
            @ApiParam(value = "top值") @RequestParam(required = false) String top) {
        return ResponseHelper.buildResponse(fireRiskSourceServiceImpl.selectForRpnTopList(stationCode, top));
    }
}
