package com.yeejoin.amos.boot.module.ccs.biz.service.impl;

import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.ccs.api.mapper.FireStationInfoMapper;
import com.yeejoin.amos.boot.module.ccs.api.service.IStatisticsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@Service
public class StatisticsServiceImpl implements IStatisticsService {

    @Autowired
    FireSignalDayStatisticsServiceImpl fireAlarmDayStatisticsService;

    @Autowired
    FireDangerDayStatisticsServiceImpl fireDangerDayStatisticsService;

    @Autowired
    FireStationInfoMapper fireStationInfoMapper;


    @Override
    public Map<String, Object> alarmAndDangerNumCount(String stationCode) throws ParseException {
        //本周开始日期
        Date weekBegin = DateUtils.beginDateOfWeek(new Date());
        //今日告警
        Integer todayAddAlarm = fireAlarmDayStatisticsService.alarmTimesCount(stationCode, DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN), DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN));
        //本周告警数量
        Integer weekAddAlarm = fireAlarmDayStatisticsService.alarmTimesCount(stationCode, DateUtils.dateFormat(weekBegin, DateUtils.DATE_PATTERN), DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN));
        //今日新增隐患
        Integer todayAddDanger = fireDangerDayStatisticsService.createDangerTimesCount(stationCode, DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN), DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN));
        //本周新增隐患
        Integer weekAddDanger = fireDangerDayStatisticsService.createDangerTimesCount(stationCode, DateUtils.dateFormat(weekBegin, DateUtils.DATE_PATTERN), DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN));
        Map<String, Object> result = new HashMap<>();
        result.put("todayAddAlarm", todayAddAlarm);
        result.put("weekAddAlarm", weekAddAlarm);
        result.put("todayAddDanger", todayAddDanger);
        result.put("weekAddDanger", weekAddDanger);
        return result;
    }

    @Override
    public Map<String, Object> alarmAndDangerTrend(String stationCode, String beginDate, String endDate) {
        //告警增长趋势
        List<String> alarmTrend = fireAlarmDayStatisticsService.alarmTimesTrend(stationCode, beginDate, endDate);
        //隐患增加趋势
        List<String> dangerTrend = fireDangerDayStatisticsService.dangerTimesTrend(stationCode, beginDate, endDate);
        Map<String, Object> result = new HashMap<>();
        result.put("alarmTrend", alarmTrend);
        result.put("dangerTrend", dangerTrend);
        return result;
    }

    @Override
    public List<Map<String, Object>> lastYearAlarmCount() {
        return fireStationInfoMapper.lastYearAlarmCount();
    }
}
