package com.yeejoin.amos.boot.module.common.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.MenuFrom;
import com.yeejoin.amos.boot.module.common.api.dto.RescueEquipmentDto;
import com.yeejoin.amos.boot.module.common.api.entity.RescueEquipment;
import com.yeejoin.amos.boot.module.common.api.mapper.RescueEquipmentMapper;
import com.yeejoin.amos.boot.module.common.api.service.IRescueEquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * 救援装备服务实现类
 *
 * @author system_generator
 * @date 2021-07-23
 */
@Service
public class RescueEquipmentServiceImpl extends BaseService<RescueEquipmentDto, RescueEquipment,
        RescueEquipmentMapper> implements IRescueEquipmentService {

    @Autowired
    DataDictionaryServiceImpl dataDictionaryService;

    /**
     * 分页查询
     */
    public Page<RescueEquipmentDto> queryForRescueEquipmentPage(Page<RescueEquipmentDto> page,
                                                                @Condition(Operator.eq) Boolean isDelete,
                                                                @Condition(Operator.eq) Long companyId,
                                                                @Condition(Operator.eq) String vehicleTypeCode) {
        return this.queryForPage(page, null, false, isDelete, companyId, vehicleTypeCode);
    }

    /**
     * 列表查询 示例
     */
    public List<RescueEquipmentDto> queryForRescueEquipmentList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrList
     * @return
     */
    public Boolean batchDelete(List<Long> sequenceNbrList) {
        List<RescueEquipment> positionStaffList =
                list(new LambdaQueryWrapper<RescueEquipment>().in(RescueEquipment::getSequenceNbr,
                        sequenceNbrList));
        positionStaffList.forEach(item -> item.setIsDelete(true));
        boolean update = updateBatchById(positionStaffList);
        return update;
    }

    public HashMap<Object, Object> getRescueEquipmentList(Long companyId) throws Exception {
        // 查询所有岗位类型
        List<MenuFrom> menuList = dataDictionaryService.getGWMCDataDictionary("JYZBLX");
        // 查询已有数据的岗位类型
        List<Long> vehicleCodeCodeList = this.baseMapper.getVehicleCodeCodeList(false, companyId);
        // 排除已有数据的，返回
        List<MenuFrom> menuListd=new ArrayList<>();
        for (int i = 0; i < menuList.size(); i++) {
            if (!vehicleCodeCodeList.contains(Long.valueOf(menuList.get(i).getKey()))) {
                menuListd.add(menuList.get(i));
            }
        }
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        objectObjectHashMap.put("JYZBLX", menuListd);
        return objectObjectHashMap;
    }
}