package com.yeejoin.equipmanage.config;
/**
 * 
 * 对全局LONG 全局解析转换为String 类型，防止前台后失真
 * 
 * **/

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.boot.jackson.JsonComponent;

import java.io.IOException;

@JsonComponent
public class LongJsonSerializer extends JsonSerializer<Long> {

	@Override
	public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
		 String text = (value == null ? null : String.valueOf(value));
		    if (text != null) {
		    	gen.writeString(text);
		    }	
	}	  	
	}
