package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexSerivce;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@Slf4j
@RestController
@Api(tags = "装备性能指标API")
@RequestMapping(value = "/equipSpecificIndex")
public class EquipmentSpecificIndexController {

    @Autowired
    private IEquipmentSpecificIndexSerivce equipmentSpecificIndexService;

    @RequestMapping(value = "/detail", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取性能指标", notes = "获取性能指标")
    public EquipmentSpecificIndex getEquipSpecificIndexDetail(@RequestParam("id") String id) {
        return equipmentSpecificIndexService.getById(id);
    }

}
