package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.dto.AssociatedEqpDTO;
import com.yeejoin.equipmanage.common.entity.vo.AssociatedEquipmentVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentDetailVO;
import com.yeejoin.equipmanage.service.IEquipmentSpecificRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;

/**
 * 联动设备关系控制器
 *
 * @author DELL
 */
@RestController
@Api(tags = "联动设备关系")
@RequestMapping(value = "/equipSpecificRelation")
public class EquipmentSpecificRelationController extends AbstractBaseController {

    @Autowired
    IEquipmentSpecificRelationService iEquipmentSpecificRelationService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询关联设备分页列表", notes = "查询关联设备分页列表")
    @GetMapping(value = "/{eqpSpecificId}/{type}")
    public IPage<AssociatedEquipmentVO> getAssociatedEquipmentByPage(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @PathVariable Long eqpSpecificId,
            @PathVariable Integer type) {
        Page page = new Page();
        page.setCurrent(current);
        if (-1 == size) {
            page.setSize(Integer.MAX_VALUE);
        } else {
            page.setSize(size);
        }
        return iEquipmentSpecificRelationService.getAssociatedEquipmentByPage(page, eqpSpecificId, type);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询已关联设备", notes = "查询已关联设备")
    @GetMapping(value = "/{eqpSpecificId}/{type}/related")
    public List<EquipmentDetailVO> getAssociatedEqpList(@PathVariable Long eqpSpecificId, @PathVariable Integer type) {
        return iEquipmentSpecificRelationService.getAssociatedEqpList(eqpSpecificId, type);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "保存关联设备", notes = "保存关联设备")
    @PostMapping(value = "/equipments")
    public void saveAssociatedEqp(@RequestBody AssociatedEqpDTO dto) {
        iEquipmentSpecificRelationService.bindRelationEquipments(dto);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "删除关联设备", notes = "删除关联设备")
    @DeleteMapping(value = "/equipments/{eqpSpecificId}")
    public void deleteAssociatedEqp(@PathVariable Long eqpSpecificId, @RequestBody List<Long> eqpIds) {
        iEquipmentSpecificRelationService.deleteRelationEquipments(eqpSpecificId, eqpIds);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据类型id和名称获取设备列表", notes = "根据类型id和名称获取设备列表")
    @GetMapping(value = "/equipments")
    public List<EquipmentDetailVO> getEqpDetailList(@RequestParam(required = false) Long categoryId,
                                                    @RequestParam(required = false) String eqpName) {
        return iEquipmentSpecificRelationService.getEqpDetailListByCategoryIdAndEqpName(categoryId, eqpName);
    }
}
