package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.equipmanage.common.dto.AnalysisReportLogDto;
import com.yeejoin.equipmanage.service.IFirePatrolReportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;

/**
 * @author wj
 * @date 2022-04-28
 */
@RestController
@Api(tags = "消防巡查报表Api")
@RequestMapping(value = "/fire-patrol-report")
@Slf4j
public class FirePatrolReportController extends BaseController {

	@Autowired
	IFirePatrolReportService iFirePatrolReportService;

	@ApiOperation(value = "下载报表", notes = "下载报表")
	@GetMapping(value = "/download")
	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
	public void download(HttpServletRequest request, HttpServletResponse response,
			@ApiParam(value = "换流站编码", required = true) @RequestParam String stationCode,
			@ApiParam(value = "开始日期", required = true) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date startDate,
			@ApiParam(value = "结束日期", required = true) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date endDate) {
		iFirePatrolReportService.download(request, response, stationCode, startDate, endDate);
	}
	
	@ApiOperation(value = "预览报表", notes = "预览报表")
	@GetMapping(value = "/preview")
	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
	public String preview(
			@ApiParam(value = "换流站编码", required = true) @RequestParam String stationCode,
			@ApiParam(value = "开始日期", required = true) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date startDate,
			@ApiParam(value = "结束日期", required = true) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date endDate) {
	    RequestContext.setProduct(getProduct());
        RequestContext.setAppKey(getAppKey());
        RequestContext.setToken(getToken());
		return iFirePatrolReportService.preview(stationCode, startDate, endDate);
	}
	
	@SuppressWarnings("unchecked")
	@ApiOperation(value = "所有站查询列表", notes = "所有站查询列表")
	@GetMapping(value = "/allPage")
	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
	public IPage<AnalysisReportLogDto> allPage(Page page, @RequestParam Integer reportType,
			@ApiParam(value = "开始日期", required = false) @RequestParam(required = false) @DateTimeFormat(pattern="yyyy-MM-dd")Date startDate,
			@ApiParam(value = "结束日期", required = false) @RequestParam(required = false) @DateTimeFormat(pattern="yyyy-MM-dd")Date endDate,
			@ApiParam(value = "换流站编码", required = false) @RequestParam(required = false) String stationCode) {
		return iFirePatrolReportService.allPage(page,reportType, startDate, endDate,stationCode);
	}
	
//	/**
//	 * 分页接口
//	 */
//	@ApiOperation(httpMethod = "GET", value = "单站查询列表", notes = "单站查询列表")
//    @GetMapping(value = "/listPage")
//	@TycloudOperation(ApiLevel = UserType.PUBLIC, needAuth = false)
//	public IPage<AnalysisReportLog> listPage(Page page, @RequestParam Integer reportType,
//			@ApiParam(value = "开始日期", required = false) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date startDate,
//			@ApiParam(value = "结束日期", required = false) @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd")Date endDate,
//			@RequestParam String stationCode) throws ParseException {
//		return iFirePatrolReportService.listPage(page,reportType, startDate, endDate,stationCode);
//	}
}
