package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.StockDetail;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.common.utils.NameUtils;
import com.yeejoin.equipmanage.service.IStockDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 库存明细
 *
 * @author wujiang
 * @date 2020-07-07
 */
@RestController
@Api(tags = "库存明细Api")
@RequestMapping(value = "/stock-detail", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class StockDetailController {

	@Autowired
	IStockDetailService iStockDetailService;

	/**
	 * 新增库存明细
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "新增库存明细", notes = "新增库存明细")
	public boolean saveStockDetail(HttpServletRequest request, @RequestBody StockDetail stockDetail) {
		return iStockDetailService.save(stockDetail);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iStockDetailService.removeById(id);
	}

	/**
	 * 修改库存明细
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "PUT", value = "修改库存明细", notes = "修改库存明细")
	public boolean updateByIdStockDetail(HttpServletRequest request, @RequestBody StockDetail stockDetail) {
		return iStockDetailService.updateById(stockDetail);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public StockDetail selectById(HttpServletRequest request, @PathVariable Long id) {
		return iStockDetailService.getById(id);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<StockDetail> listPage(String pageNum, String pageSize, StockDetail stockDetail) {

		Page<StockDetail> pageBean;
		QueryWrapper<StockDetail> stockDetailQueryWrapper = new QueryWrapper<>();
		Class<? extends StockDetail> aClass = stockDetail.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(stockDetail);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(stockDetail);
						stockDetailQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(stockDetail);
						stockDetailQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(stockDetail);
						stockDetailQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(stockDetail);
						stockDetailQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<StockDetail> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iStockDetailService.page(pageBean, stockDetailQueryWrapper);
		return page;
	}

	/**
	 * 指定位置指定分类下库存查询 以分类为主（灭火药剂入账列表）
	 * 
	 * @return
	 */
	@RequestMapping(value = "/category", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分类查询", notes = "列表分类查询")
	public IPage<StockDetail> pageCategoryStock(String pageNum, String pageSize, String category,
			Long warehouseStructureId) {
		Page<EquipmentDetail> pageBean;
		IPage<StockDetail> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iStockDetailService.pageCategoryStock(pageBean, category, warehouseStructureId);
		return page;
	}

	/**
	 * 指定位置指定分类库存查询 以库存为主（灭火药剂装载列表）
	 * 
	 * @return
	 */
	@RequestMapping(value = "/stock", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<StockDetail> pageStockCategory(String pageNum, String pageSize, String category,
			Long warehouseStructureId) {
		Page<StockDetail> pageBean;
		IPage<StockDetail> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iStockDetailService.pageStockCategory(pageBean, category, warehouseStructureId);
		return page;

	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/place/equipment", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<StockDetail> listPage(String pageNum, String pageSize, Long warehouseStructureId,
			Long equipmentDetailId) {

		Page<StockDetail> pageBean;
		IPage<StockDetail> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iStockDetailService.pagePlaceEquip(pageBean, equipmentDetailId, warehouseStructureId);
		return page;
	}

	/**
	 * <pre>
	 * &#64;Description:
	 * </pre>
	 *
	 * @MethodName:
	 * @Param:
	 * @Return: ResponseModel
	 * @Throws
	 * @Author keyong
	 * @Date 2021/6/17 13:53
	 */
	@RequestMapping(value = "/airport/person/bind", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "人员装备列装接口", notes = "人员装备列装", produces = "application/json;charset=UTF-8")
	public ResponseModel loadOnPerson(@RequestBody List<String> ids) {
		List<StockDetail> stockDetails = null;
		if (0 < ids.size()) {
			stockDetails = iStockDetailService.loadOnPerson(ids);
		}
		return CommonResponseUtil.success(stockDetails);
	}

	/**
	 * <pre>
	 * &#64;Description:
	 * </pre>
	 *
	 * @MethodName:
	 * @Param:
	 * @Return: ResponseModel
	 * @Throws
	 * @Author keyong
	 * @Date 2021/6/17 11:53
	 */
	@RequestMapping(value = "/airport/car", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "车载装备回库接口", notes = "车载装备卸载", produces = "application/json;charset=UTF-8")
	public ResponseModel unloadOnCar(@RequestBody Map<String, Object> map) {
		StockDetail stockDetail = iStockDetailService.unloadOnCar(map);
		return CommonResponseUtil.success(stockDetail);
	}

	/**
	 * <pre>
	 * &#64;Description:
	 * </pre>
	 *
	 * @MethodName:
	 * @Param:
	 * @Return: ResponseModel
	 * @Throws
	 * @Author keyong
	 * @Date 2021/6/17 11:59
	 */
	@RequestMapping(value = "/airport/person", method = RequestMethod.POST)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "POST", value = "人员装备回库接口", notes = "人员装备回库", produces = "application/json;charset=UTF-8")
	public ResponseModel unloadOnPerson(@RequestBody Map<String, Object> map) {
		StockDetail stockDetail = iStockDetailService.unloadPerson(map);
		return CommonResponseUtil.success(stockDetail);
	}
}
