package com.yeejoin.equipmanage.fegin;

import com.yeejoin.equipmanage.common.entity.dto.IndexLogsRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;


/**
 * @author DELL
 */
//@FeignClient(name = "${iot.vehicle.track}", path = "iot", configuration = {FeignConfiguration.class})
@FeignClient(name = "AMOS-API-IOT", path = "iot", configuration = { FeignConfiguration.class })
public interface IotFeign {

    @RequestMapping(value = "/v1/livedata/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectList(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam(value = "deviceName") String deviceName,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);

    @RequestMapping(value = "/v1/livedata/page", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectPage(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam(value = "deviceName") String deviceName,
            @RequestParam(required = false, value = "fieldKey") String fieldKey,
            @RequestParam(value = "current") Integer current,
            @RequestParam(value = "size") Integer size);



    @RequestMapping(value = "v1/livedata/common/top", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectOne(
            @RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @RequestParam(value = "top") String top,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam( required = false, value = "deviceName") String deviceName,
            @RequestParam("FHS_PressurePump_Start") String key,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);

    @RequestMapping(value = "v1/livedata/common/top/single-field", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel topSingleField(
            @RequestParam(value = "top") String top,
            @RequestParam(value = "productKey") String productKey,
            @RequestParam( required = false, value = "deviceName") String deviceName,
            @RequestParam("FHS_PressurePump_Start") String key,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);

    @RequestMapping(value = "v1/livedata/common/list", method = RequestMethod.GET, consumes = "application/json")
    ResponseModel selectListNew(
            @RequestParam(value = "measurement") String measurement,
            @RequestParam( required = false, value = "deviceName") String deviceName,
            @RequestParam(value = "timeStart") String beginDate,
            @RequestParam(value = "timeEnd") String endDate,
            @RequestParam("FHS_PressurePump_Start") String key,
            @RequestParam(required = false, value = "fieldKey") String fieldKey);


    @RequestMapping(value = "v1/livedata/index/logs", method = RequestMethod.POST, consumes = "application/json")
    ResponseModel<Map<String ,Object>> getEquipAlarmLog(@RequestBody IndexLogsRequest indexLogsRequest            );

    @GetMapping("/v1/livedata/common/list")
    ResponseModel<List<Object>> getLiveData(@RequestParam("measurement") String measurement,
                                            @RequestParam("deviceName") String deviceName,
                                            @RequestParam("timeStart") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss") Date timeStart,
                                            @RequestParam("timeEnd") @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")Date timeEnd);
}
