package com.yeejoin.equipmanage.fegin;

import com.yeejoin.amos.boot.biz.common.feign.MultipartSupportConfig;
import com.yeejoin.equipmanage.common.entity.MaintenanceResourceData;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;

// 维保调用
@FeignClient(name = "${maintenance.feign.name}", configuration = {MultipartSupportConfig.class})
public interface MaintenanceFeign {

    @RequestMapping(value = "/maintenance/api/equipmnetRule/equipmnetInput", method = RequestMethod.POST, consumes = "application/json")
    Object getEquipDetail(@RequestBody(required = true) String equipRuleParams);

    @DeleteMapping(value = "/maintenance/api/syn/{ids}/point", consumes = "application/json")
    ResponseModel pointDelete(@PathVariable("ids") String ids);

    @RequestMapping(value = "/maintenance/api/point/equipmentInput", method = RequestMethod.POST, consumes = "application/json")
    CommonResponse getPlanTaskList(
    							   @RequestHeader("appKey") String appKey,
                                   @RequestHeader("product") String product,
                                   @RequestHeader("token") String token,
                                   @RequestBody ArrayList<MaintenanceResourceData> list);

    @GetMapping(value = "/maintenance/api/check/page", consumes = "application/json")
    CommonResponse getCheckRecord(
    		@RequestHeader("appKey") String appKey,
            @RequestHeader("product") String product,
            @RequestHeader("token") String token,
            @ApiParam(value = "查询范围") @RequestParam(value = "userId", required = false) String userId,
            @ApiParam(value = "时间范围") @RequestParam(value = "timeType", required = false) String timeType,
            @ApiParam(value = "维保结果") @RequestParam(value = "result", required = false) String result,
            @ApiParam(value = "排序规则") @RequestParam(value = "orderRule", required = false) String orderRule,
            @ApiParam(value = "开始时间") @RequestParam(value = "beginTime", required = false) String beginTime,
            @ApiParam(value = "结束时间") @RequestParam(value = "endTime", required = false) String endTime,
            @ApiParam(value = "维保人员") @RequestParam(value = "personId", required = false) String person,
            @ApiParam(value = "业主单位") @RequestParam(value = "teamId", required = false) String teamId,
            @ApiParam(value = "设施Id") @RequestParam(value = "equipId", required = false) String equipId,
            @ApiParam(value = "当前页") @RequestParam(value = "pageNumber") int pageNumber,
            @ApiParam(value = "页大小") @RequestParam(value = "pageSize") int pageSize);


}

