package com.yeejoin.equipmanage.initbean;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.WlCarMileage;
import com.yeejoin.equipmanage.service.ICarService;
import com.yeejoin.equipmanage.service.impl.WlCarMileageServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Component
@Slf4j
public class JxiopCarReCountTimeBean {
    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private WlCarMileageServiceImpl wlCarMileageServiceImpl;
    @Autowired
    private ICarService iCarService;

    @PostConstruct
    public void reCountTime() {
        log.info("---------------------车辆重新开始计时：：开始-------------------------");
        List<WlCarMileage> wlCarMileageList = wlCarMileageServiceImpl.list(new QueryWrapper<WlCarMileage>().isNull("end_time"));
        for (int i = 0; i < wlCarMileageList.size(); i++) {
            Car car = iCarService.getOne(new QueryWrapper<Car>().eq("iot_code", wlCarMileageList.get(i).getIotCode()));
            if(ObjectUtils.isNotEmpty(car)){
                String coordinate = String.valueOf(car.getLongitude()) + "," + String.valueOf(car.getLatitude());
                redisTemplate.opsForValue().set(car.getIotCode(), coordinate, 5, TimeUnit.MINUTES);
            }
        }
        log.info("---------------------车辆重新开始计时：：结束-------------------------");
    }
}
