package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.EquipmentManageEntity;
import com.yeejoin.equipmanage.common.vo.EquipmentManageVo;
import com.yeejoin.equipmanage.common.vo.FileUploadVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface EquipmentManageMapper extends BaseMapper<EquipmentManageEntity> {
    /**
     * 获取消防设施管理信息和数量
     *
     * @return
     */
    List<EquipmentManageVo> queryEquipmenInfo(Map<String, Object> map);

    Long queryEquipmenCount(Map<String, Object> map);

    List<EquipmentManageVo> getUtils();

    List<EquipmentManageVo> getSystemList();

    int deleteByid(String param);

    int checkCode(String param);

    int insertEquipment(EquipmentManageVo vo);

    int insertFile(FileUploadVo vo);

    List<FileUploadVo> getFiles(@Param("id") String id, @Param("type") String type);

    int updateEquipment(EquipmentManageVo vo);

    int updateFile(FileUploadVo vo);

    int chekcName(EquipmentManageVo vo);

    int deleteFilre(String id);

    List<Map<String, Object>> getNotFireSystemList(String alarmSystemCode);
}
