package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentStandard;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentStandardVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface EquipmentStandardMapper extends BaseMapper<EquipmentStandard> {

	/**
	 * 规范配置分页列表
	 * @param page 分页参数
	 * @param orgCode 组织机构
	 * @param standardKey 维保规范
	 * @param equipmentName 装备定义名称
	 * @return IPage<EquipmentStandardVO>
	 */
	IPage<EquipmentStandardVO> findEquipmentStandardList(Page page, @Param("orgCode") String orgCode,@Param("standardKey") String standardKey,@Param("equipmentName") String equipmentName);
	 
	 List<Map<String,String>> getNoAddEquipmentStandardNameList(String orgCode);
	 
	 EquipmentStandardVO  findById(Long id);
}
