package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.dto.MaintenanceResourceDataDto;
import com.yeejoin.equipmanage.common.entity.MaintenanceResourceData;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 消防设施资源数据Mapper接口
 *
 * @author gaojianqiang
 * @date 2021-07-16
 */
public interface MaintenanceResourceDataMapper extends BaseMapper<MaintenanceResourceData> {
    /**
     * 查询消防设施资源数据
     *
     * @param id 消防设施资源数据ID
     * @return 消防设施资源数据
     */
    public MaintenanceResourceData selectMaintenanceResourceDataById(Long id);

    /**
     * 查询消防设施资源数据列表
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 消防设施资源数据集合
     */
    public List<MaintenanceResourceData> selectMaintenanceResourceDataList(MaintenanceResourceData maintenanceResourceData);

    public List<MaintenanceResourceData> selectMaintenanceResourceDataListByclassifyId();

    /**
     * 新增消防设施资源数据
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 结果
     */
    public int insertMaintenanceResourceData(MaintenanceResourceData maintenanceResourceData);

    /**
     * 修改消防设施资源数据
     *
     * @param maintenanceResourceData 消防设施资源数据
     * @return 结果
     */
    public int updateMaintenanceResourceData(MaintenanceResourceData maintenanceResourceData);

    /**
     * 删除消防设施资源数据
     *
     * @param id 消防设施资源数据ID
     * @return 结果
     */
    public int deleteMaintenanceResourceDataById(Long id);

    /**
     * 批量删除消防设施资源数据
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteMaintenanceResourceDataByIds(Long[] ids);

    List<MaintenanceResourceData> getMaintenanceResourceDataList(String orgCode);

    /**
     * 获取已经关联的消防实施
     *
     * @param keyList
     * @return
     */
    List<String> getRelationKey(@Param("list") List<String> keyList);

    List<String> getBandWbCompany(String maintenanceCompanyId);

    IPage<MaintenanceResourceDataDto> getClassifyPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, String expirationTimeSort);

    IPage<MaintenanceResourceDataDto> getFireFacilityPage(Page page, Long maintenanceCompanyId, Long ownerUnitId, Long fireFightSysId, Long classifyId, List<Long> buildingId, String status);

    List<MaintenanceResourceData> getFireFacilityList(Long id, Integer type);

    /**
     * 删除MaintenanceResource前统计
     * @param ids
     * @return
     */
    List<MaintenanceResourceDataDto> deleteBeforeMainResCount(@Param("list") Long[] ids);

    Integer deleteClassifyList(@Param("list") List<MaintenanceResourceDataDto> classifyList);

    Integer deleteFireFightSysList(@Param("list") List<MaintenanceResourceDataDto> fireFightSysList);
}
