package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.WlCarMileage;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 车量里程表 Mapper 接口
 *
 * @author duanwei
 * @date 2023-02-01
 */
public interface WlCarMileageMapper extends BaseMapper<WlCarMileage> {

	Page<WlCarMileage> page(Page<WlCarMileage> page,@Param("wlCarMileage") WlCarMileage wlCarMileage, @Param("mileageParameter") Double mileageParameter);

	Double totalMileage(String iotCode);
	@Select("select count(1) from wl_car_mileage where start_time is not null and end_time is null and iot_code = #{iotCode}")
	Integer getUncompleteMileagByIotCode(String iotCode);
	List<WlCarMileage> list(@Param("date") String date);
	Double getTotalTravelByIotCodeAndDate(String date,String iotCode);

	Double getTotalTravelByIotCodeAndDateProd(String startDate, String endDate, String iotCode);
}
