package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.dto.EquipTypeAmountPageDTO;
import com.yeejoin.equipmanage.common.entity.vo.EquipTypeImgAmountVO;
import com.yeejoin.equipmanage.common.vo.PressurePumpCountVo;

import java.util.List;
import java.util.Map;

/**
 *
 * 四横八纵应急模块接口服务类
 *
 *
 */
public interface IEmergencyService {
    /**
     * @return
     */
    List<Map<String, Object>> getSystemState(String bizOrgCode);
    Map<String, Object> getSystemAlarmCount(String status, int current, int size,String bizOrgCode);

    /**
     * @return
     */
    List<Map<String, Object>> getCAFSWaterTankInfo();

    Map<String, Object> emergencyMaterials();

    Map<String, Object> getEmergencyMaterials(String bizOrgCode);

    Page<Map<String, Object>> emergencyMaterialsDetails(Page<Map<String, Object>> page, String bizOrgCode);

    Page<Map<String, Object>> selectFireMonitor(Page<Map<String, Object>> page, String bizOrgCode,String code);

    Page<Map<String, Object>> selectFoamTank(Page<Map<String, Object>> page);

    Page<Map<String, Object>> selectOilDrainage(Page<Map<String, Object>> page, String bizOrgCode, String code);

    Page<Map<String, Object>> selectGasExtinguishing(Page<Map<String, Object>> page, String bizOrgCode, String code);

    Page<Map<String, Object>> selectPressureFlow(Page<Map<String, Object>> page, String bizOrgCode);

    List<Map<String, Object>> selectAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType);

    List<Map<String, Object>> selectAlarmAnalysisCount(String systemType, String startDate, String endDate);

    Map<String, Object> systemAndCar();

    List<Map<String, Object>> selectFireCannonAlarmAnalysisPie(String startDate, String endDate, String systemType);

    List<Map<String, Object>> waterSystemAlarmAnalysisPie(String startDate, String endDate, String systemType);

    List<Map<String, Object>> waterSystemAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType);

    List<Map<String, Object>> fireCannonSystemAlarmAnalysis(String startDate, String endDate, String dataType, String date, String systemType);

    List<Map<String, Object>> getEquipExpiryStatistics(Integer expiryDayNum);

    List<Map<String, String>> getEquipExpiryList(Integer expiryDayNum);

    Map<String, Integer> getStockEquipStatistics();

    Map<String, Object> getPressurePumpStatusChart(String startTime, String endTime, String bizOrgCode);

    Map<String, Object> getPressurePumpStatusDetailChart(String startTime, String endTime, String bizOrgCode);

    List<Map<String, Object>> getPressurePumpDiagnosticAnalysis(String bizOrgCode);

    Page<Map<String, Object>> alarmList(Page<Map<String, Object>> page,String bizOrgCode, String systemCode, List<String> types, List<String> emergencyLevels, String name, Integer cleanStatus, Integer handleStatus);

    Map<String, List<PressurePumpCountVo>> getPressurePumpDay();

    /**
     * 稳压泵启动统计
     * @param startTime
     * @param endTime
     * @param bizOrgCode
     * @return
     */
    Map<String, Object> getPressurePumpStartStatistics(String startTime, String endTime, String bizOrgCode);

    IPage<EquipTypeImgAmountVO> getEmergencyEquipList(EquipTypeAmountPageDTO equipTypeAmountPage);

    List<Map<String, Object >> getEquipStatistic(String bizOrgCode, String equipCodeKey);
}
