package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificIndex;
import com.yeejoin.equipmanage.common.entity.Video;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentIndexVO;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentSecificDetailVO;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificIndexMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificIndexSerivce;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @author ZeHua Li
 * @date 2020/10/30 11:34
 * @since v2.0
 */
@Service
public class EquipmentSpecificIndexSerivceImpl extends ServiceImpl<EquipmentSpecificIndexMapper, EquipmentSpecificIndex> implements IEquipmentSpecificIndexSerivce {
    @Override
    public List<EquipmentSpecificIndex> getEquipmentSpeIndexByEquipmentSecificId(Long id) {
        return this.baseMapper.getEquipmentSpeIndexByEquipmentSecificId(id);
    }

    @Override
    public List<Video> getVideoByEquipmentSecificId(Long id) {
        return this.baseMapper.getVideoByEquipmentSecificId(id);
    }

    @Override
    public EquipmentSecificDetailVO getEquipmentDetailBySecificId(Long id) {
        return this.baseMapper.getEquipmentDetailBySecificId(id);
    }

    @Override
    public List<Map<String, Object>> selectEquProperty(Long id) {
        return this.baseMapper.selectEquProperty(id);
    }

    @Autowired
    EquipmentSpecificIndexMapper equipmentSpecificIndexMapper;

    @Override
    public List<EquipmentSpecificIndex> getEquipmentSpeIndexBySpeIotCode(String iotCode) {
        List<EquipmentSpecificIndex> list = equipmentSpecificIndexMapper.getEquipmentSpeIndexBySpeIotCode(iotCode);
        return list;
    }

    @Override
    public List<Map<String, Object>> selectEquList(int pageNum, int pageSize, String name, String standard, String manufacturerName) {
        return equipmentSpecificIndexMapper.selectEquList(pageNum, pageSize, name, standard, manufacturerName);
    }

    @Override
    public List<Map<String, Object>> selectEquListcount(String name, String standard,
                                                        String manufacturerName) {
        return equipmentSpecificIndexMapper.selectEquListcount(name, standard, manufacturerName);

    }

    @Override
    public void updateIndexValueBatchByUniqueKey(Long equipmentSpecificId, List<EquipmentSpecificIndex> equipmentIndexId) {
        this.baseMapper.updateIndexValueBatch(equipmentSpecificId, equipmentIndexId);
    }

    @Override
    public List<EquipmentIndexVO> getEquipSpecificIndexList(EquipmentIndexVO equipmentIndexVo) {
        List<EquipmentIndexVO> indexVoList = this.baseMapper.getEquipSpecificIndexList(equipmentIndexVo);
        if (indexVoList != null && !indexVoList.isEmpty()) {
            return indexVoList;
        } else {
            return Lists.newArrayList();
        }
    }

    @Override
    public List<EquipmentIndexVO> getEquipIndexBySpecificIdIn(List<String> specificDetails) {
        List<EquipmentIndexVO> indexVoList = this.baseMapper.getEquipIndexBySpecificIdIn(specificDetails);
        if (indexVoList != null && !indexVoList.isEmpty()) {
            return indexVoList;
        } else {
            return Lists.newArrayList();
        }
    }

    @Override
    public List<EquipmentIndexVO> getEquipIndexByIdIn(List<Long> specificIndexIds) {
        List<EquipmentIndexVO> indexVoList = this.baseMapper.getEquipIndexByIdIn(specificIndexIds);
        if (indexVoList != null && !indexVoList.isEmpty()) {
            return indexVoList;
        } else {
            return Lists.newArrayList();
        }
    }

}
