package com.yeejoin.amos.fas.business.dao.repository;

import com.yeejoin.amos.fas.dao.entity.Equipment;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository("iEquipmentDao")
public interface IEquipmentDao extends BaseDao<Equipment, Long> {

	Optional<Equipment> findById(Long id);

	@Query(value = "SELECT count(1) FROM `f_fmea_equipment_point` WHERE important_equipment_id in ?1", nativeQuery = true)
	int countFemaRelation(String[] idArray);

	@Query(value = "SELECT COUNT(1) FROM f_equipment WHERE `status` = ?1", nativeQuery = true)
    int countByStatus(int status);

	@Query(value = "SELECT ss.equipment_specific_id FROM(SELECT si.equipment_specific_id, si.equipment_index_id FROM wl_equipment_specific_index si WHERE si.equipment_specific_id IN ( SELECT fe.fire_equipment_id FROM f_equipment_fire_equipment fe WHERE fe.equipment_id = ?1 )  ) ss LEFT JOIN wl_equipment_index ei ON ss.equipment_index_id = ei.id WHERE ei.type_code = ?2", nativeQuery = true)
	List<Object> getReserveEquipById(Long id, String typeCode);

	Optional<Equipment> findFirstByCodeIs(String code);
}
