package com.yeejoin.amos.fas.business.feign;


import com.yeejoin.amos.boot.biz.common.feign.FeignConfiguration;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(name="${dutyMode.fegin.name}", fallback=DutyModeServerFallback.class, configuration=FeignConfiguration.class)
public interface IDutyModeServer {

	@RequestMapping(value = "/duty/duty/listByDay", method = RequestMethod.POST,consumes = "application/json")
	public CommonResponse dutyListByDay(
			@RequestHeader(name="appKey",required = true) String appKey,
			@RequestHeader(name="product",required = true) String product,
			@RequestHeader(name="token",required = true) String token,
			@RequestHeader(name="orgCode",required = true) String orgCode,
			@RequestBody String param);

	@RequestMapping(value = "/duty/duty/dutyListByDate", method = RequestMethod.POST,consumes = "application/json")
	public CommonResponse dutyListByDate(
			@RequestHeader(name="appKey",required = true) String appKey,
			@RequestHeader(name="product",required = true) String product,
			@RequestHeader(name="token",required = true) String token,
			@RequestHeader(name="orgCode",required = true) String orgCode,
			@RequestBody String param);
}
