package com.yeejoin.amos.fas.business.jpush;

import cn.jpush.api.push.model.PushPayload;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class AppMessagePushService {

    protected static final Logger log = LoggerFactory.getLogger(AppMessagePushService.class);
    
    @Autowired
    private com.yeejoin.amos.fas.business.feign.PushFeign PushFeign;
    
    private PushPayload buildPushPayload(PushMsgParam response) {
    	CommonResponse  commonResponse = PushFeign.buildPushPayload(response);
    	return (PushPayload)commonResponse.getDataList();
    }

    public void sendMessage(PushMsgParam response) {
        try {
            CommonResponse commonResponse = PushFeign.sendMessageone(response);
        } catch (Exception e) {
            log.error("极光推送异常", e);
        }
    }

}
