package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.DictMapper;
import com.yeejoin.amos.fas.business.dao.repository.IDictDao;
import com.yeejoin.amos.fas.business.service.intfc.IDictService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.dao.entity.Dict;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@Service("dictService")
public class DictServiceImpl implements IDictService {

	@Autowired
	private IDictDao dictDao;
	@Autowired
	private DictMapper dictMapper;
	
	@Override
	public Page<Dict> getDictPage(Dict dict, CommonPageable commonPageable) {
		long total = dictMapper.countDict(dict);
		List<Dict> content = dictMapper.getDictPage(dict, commonPageable.getPageNumber(), commonPageable.getPageSize());
		Page<Dict> result = new PageImpl<Dict>(content, commonPageable, total);
		return result;
	}

	@Override
	public List<Dict> getDictListByIds(Long[] ids) {
		List<Long> resultList = new ArrayList<>(ids.length);
		Collections.addAll(resultList, ids);
		return dictDao.findAllById(resultList);
	}

	@Override
	public Dict getDictById(long id) {
		
		Optional<Dict> dict1=dictDao.findById(id);
		Dict  dict=null;
		if(dict1.isPresent()){
			dict=dict1.get();
		}
		return dict;
	}

	@Override
	public void deleteDictById(long id) {
		dictDao.deleteById(id);
	}

	@Override
	public void deleteDictByIds(long[] ids) {
		for (long id : ids) {
			dictDao.deleteById(id);
		}	
	}

	@Override
	public void saveDict(Dict dict) {
		dictDao.save(dict);
	}

	@Override
	public List<Dict> getDictList(Dict dict) {
		return dictMapper.getDictList(dict);
	}

}
