package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentCategoryService;
import com.yeejoin.amos.fas.dao.entity.EquipmentCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.TreeBuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * 装备分类 服务实现类
 *
 * @author zjw
 * @date 2020-11-04
 */
@Service
public class EquipmentCategoryServiceImpl  implements IEquipmentCategoryService {

    @Autowired
    private EquipmentCategoryMapper equipmentCategoryMapper;


    @Override
    public List<EquipmentCategory> list( ) {
        return equipmentCategoryMapper.list();
    }

    @Override
    public List<EquipmentCategory> getAllTree(Long root) {
        List<EquipmentCategory> list = equipmentCategoryMapper.list();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        Long root123 = -1L;
        list.forEach(eq -> { if(eq.getParentId() == null) { eq.setParentId(root123);}});
        if (root == null) {
            root = root123;
        }
        Collection<EquipmentCategory> bulid = TreeBuilder.bulid(list, root);
        return new ArrayList<>(bulid);
    }
}
