package com.yeejoin.amos.fas.business.service.impl;

import com.yeejoin.amos.fas.business.dao.mapper.FireEquipMapper;
import com.yeejoin.amos.fas.business.dao.mapper.FireEquipPointMapper;
import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentEntity;
import com.yeejoin.amos.fas.business.entity.mybatis.FireEquipmentPointEntity;
import com.yeejoin.amos.fas.business.service.intfc.IEquipmentService;
import com.yeejoin.amos.fas.business.service.intfc.IFireEquipPontService;
import com.yeejoin.amos.fas.business.vo.EquipCommunicationData;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import com.yeejoin.amos.fas.core.util.StringUtil;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("fireEquipPoint")
public class FireEquipPointServiceImpl implements IFireEquipPontService {

    @Autowired
    private FireEquipPointMapper fireEquipPointMapper;

    @Autowired
    private IEquipmentService iEquipService;

    @Autowired
    private FireEquipMapper fireEquipMapper;

    public Page queryByFireEquimt(Long fireEqumntId, String name, CommonPageable pageable) {
        Long total = fireEquipPointMapper.queryCountForPage(fireEqumntId, name);
        List<Map> content = fireEquipPointMapper.queryForPage(fireEqumntId, name, pageable.getOffset(), pageable.getPageSize());
        content.forEach(action -> {
            if (StringUtil.isNotEmpty(action.get("code"))) {
                EquipCommunicationData data = iEquipService.findFireEquipDataByPointCode(action.get("code").toString());
                if (StringUtil.isNotEmpty(data)) {
                    action.put("value", data.getState());
                }
            }
        });

        Page result = new PageImpl(content, pageable, total);
        return result;
    }

    @Override
    public CommonResponse queryByMap(Map<String, Object> map) {
    	int pageNumber = map.get("pageNumber") != null ? Integer.parseInt(map.get("pageNumber").toString()) : 0;
        int pageSize = map.get("pageSize") != null ? Integer.parseInt(map.get("pageSize").toString()) : 0;
        CommonPageable commonPageable = new CommonPageable(pageNumber, pageSize);
        Long total = fireEquipPointMapper.countByMap(map);
        if (total.equals(0L)) {
            return CommonResponseUtil.success(new PageImpl<>(Lists.newArrayList(), commonPageable, total));
        }
        map.put("offset", pageNumber*pageSize);
        List<FireEquipmentPointEntity> list = fireEquipPointMapper.listByMap(map);
        return CommonResponseUtil.success(new PageImpl<>(list, commonPageable, total));
    }

    @Override
    public CommonResponse batchBindToEquipment(Long deviceId, List<Long> pointIds) {
        fireEquipPointMapper.updatefireEquipmentIdByIds(deviceId, pointIds);
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse batchUnbindToEquipment(List<Long> pointIds) {
        fireEquipPointMapper.updatefireEquipmentIdByIds(0L, pointIds);
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse update(FireEquipmentPointEntity fireEquipmentPointEntity) {
        FireEquipmentPointEntity pointEntity = fireEquipPointMapper.getById(fireEquipmentPointEntity.getId());
        if (pointEntity == null) {
            return CommonResponseUtil.failure("监测点不存在");
        }
        String pointCode = fireEquipmentPointEntity.getCode();
        if (pointCode != null && !pointEntity.getCode().equals(pointCode)) {
            FireEquipmentPointEntity existPoint = fireEquipPointMapper.getByCode(pointCode);
            if (existPoint != null) {
                return CommonResponseUtil.failure("监测点编号已经存在");
            }
        }
        fireEquipPointMapper.update(fireEquipmentPointEntity);
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse batchDelete(List<Long> ids) {
        fireEquipPointMapper.deleteBatchByIds(ids);
        return CommonResponseUtil.success();
    }

    @Override
    public CommonResponse listByType(Integer type) {
        List<FireEquipmentEntity> equipments = fireEquipMapper.listByType(type);
        return CommonResponseUtil.success(equipments);
    }
}
