package com.yeejoin.amos.boot.module.jcs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jcs.api.dto.RallyPointDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.RallyPoint;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.RallyPointServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 集结点
 *
 * @author system_generator
 * @date 2021-08-25
 */
@RestController
@Api(tags = "集结点Api")
@RequestMapping(value = "/rally-point")
public class RallyPointController extends BaseController {

    @Autowired
    RallyPointServiceImpl rallyPointServiceImpl;

    /**
     * 新增集结点
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增集结点", notes = "新增集结点")
    public ResponseModel<RallyPointDto> save(@RequestBody RallyPointDto model) {
        model = rallyPointServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新集结点", notes = "根据sequenceNbr更新集结点")
    public ResponseModel<RallyPoint> updateBySequenceNbrRallyPoint(@RequestBody RallyPointDto model,
																	  @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        model.setSequenceNbr(sequenceNbr);
        RallyPoint rallyPoint = new RallyPoint();
        BeanUtils.copyProperties(model, rallyPoint);
        rallyPointServiceImpl.saveOrUpdate(rallyPoint);
        return ResponseHelper.buildResponse(rallyPoint);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除集结点", notes = "根据sequenceNbr删除集结点")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(rallyPointServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个集结点", notes = "根据sequenceNbr查询单个集结点")
    public ResponseModel<RallyPointDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(rallyPointServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "集结点分页查询", notes = "集结点分页查询")
    public ResponseModel<Page<RallyPointDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<RallyPointDto> page = new Page<RallyPointDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(rallyPointServiceImpl.queryForRallyPointPage(page));
    }

    /**
     * 根据警情id查询集结点列表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据警情id查询集结点列表", notes = "根据警情id查询集结点列表")
    @GetMapping(value = "/list")
    public ResponseModel<List<RallyPointDto>> selectForList(@RequestParam String alertId) {
        return ResponseHelper.buildResponse(rallyPointServiceImpl.queryForRallyPointList(alertId));
    }
}
