package com.yeejoin.amos.boot.module.jcs.biz.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yeejoin.amos.boot.module.common.api.feign.JcsControlServerClient;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.ControllerEquipDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.Controller;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerEquip;
import com.yeejoin.amos.boot.module.jcs.api.entity.ControllerLog;
import com.yeejoin.amos.boot.module.jcs.api.mapper.ControllerEquipMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IControllerEquipService;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;
import java.util.List;

/**
 * <pre>
 * 控制器设备 服务实现类
 * </pre>
 *
 * @author gwb
 * @version $Id: ControllerEquipServiceImpl.java, v 0.1 2021年8月20日 上午10:16:33 gwb Exp $
 */
@Service
public class ControllerEquipServiceImpl extends BaseService<ControllerEquipDto, ControllerEquip, ControllerEquipMapper> implements IControllerEquipService {
    public static final String CONTROLLER_STATE_CHANGED_TOPIC = "controllerStateChanged";

    @Autowired
    JcsControlServerClient jcsControlServerClient;

    @Autowired
    ControllerLogServiceImpl controllerLogServiceImpl;

    @Autowired
    private EmqKeeper emqKeeper;

    public List<ControllerEquipDto> queryAllForList() {
        return this.queryForList("", false);
    }

    /**
     * 改变警铃状态 0关闭，1开启
     */
    @Async
    public void changeBell(ControllerDto controller, String type) {
        if (controller == null) return;
        controller.setState(type);
        saveLog(controller);
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.sendBellAction(controllerEquip.getNum(), type));
    }

    /**
     * 改变广播状态 0关闭，1开启
     */
    @Async
    public void changeBroadcast(ControllerDto controller, String type) {
        if (controller == null) return;
        controller.setState(type);
        saveLog(controller);
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.sendFileAction(controllerEquip.getNum(), ""));
    }

    /**
     * 改变车库门状态 0关闭，1开启
     */
    @Async
    public void changeDoor(ControllerDto controller, String type) {
        if (controller == null) return;
        controller.setState(type);
        saveLog(controller);
        List<ControllerEquip> list = getControllerEquips(controller);
        list.forEach(controllerEquip -> jcsControlServerClient.writeStateAction(controller.getIp(), controller.getPort(), Integer.parseInt(controllerEquip.getNum()), type));
    }

    private List<ControllerEquip> getControllerEquips(ControllerDto controller) {
        LambdaQueryWrapper<ControllerEquip> wrapper = new LambdaQueryWrapper<ControllerEquip>().eq(ControllerEquip::getControllerSeq, controller.getSequenceNbr());
        return list(wrapper);
    }

    /**
     * 保存操作日志
     */
    private void saveLog(ControllerDto controller) {
        if (controller == null) return;
        ControllerLog controllerLog = new ControllerLog();
        controllerLog.setControllerSeq(controller.getSequenceNbr());
        controllerLog.setState(controller.getState());
        controllerLog.setExecuteDate(new Date());
        controllerLogServiceImpl.save(controllerLog);
        // 分发状态变更通知
        try {
            String value = new ObjectMapper().writeValueAsString(controller);
            emqKeeper.getMqttClient().publish(CONTROLLER_STATE_CHANGED_TOPIC, value.getBytes(), 2, true);
        } catch (MqttException | JsonProcessingException e) {
            e.printStackTrace();
        }
    }
}
