package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagInstanceModel;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagInstance;
import com.yeejoin.amos.knowledgebase.face.service.TagInstanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * <p>
 * 标签实例 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "taginstance")
@RequestMapping(value = "/v1/taginstance")
@Api(tags = "knowledgebase-标签实例")
public class TagInstanceResource {

    private final Logger logger = LogManager.getLogger(TagInstanceResource.class);
    @Autowired
    private TagInstanceService tagInstanceService;
    
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据主键查询实例标签")
    @RequestMapping(value = "find/{id}", method = RequestMethod.GET)
    public ResponseModel<KnowledgeTagInstance> findById(@PathVariable("id") Long id) {
        return ResponseHelper.buildResponse(tagInstanceService.findById(id));
    }
    
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据targetSeq查询实例标签")
    @RequestMapping(value = "targetSeq/{id}", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeTagInstanceModel>> queryListByTargetSeq(@PathVariable("id") Long id) {
        return ResponseHelper.buildResponse(tagInstanceService.queryListByTargetSeq(id));
    }
    
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "根据targetSeq查询实例标签")
    @RequestMapping(value = "getTarget/byName", method = RequestMethod.GET)
    public ResponseModel<List<KnowledgeTagInstanceModel>> queryListByTagName(@RequestParam String name) {
        return ResponseHelper.buildResponse(tagInstanceService.queryListByTagName(name));
    }
}
