package com.yeejoin.amos.latentdanger.business.service.intfc;

import java.util.List;

import org.springframework.data.domain.Page;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.latentdanger.business.util.DaoCriteria;
import com.yeejoin.amos.latentdanger.core.common.request.CommonPageable;
import com.yeejoin.amos.latentdanger.dao.entity.Msg;
import com.yeejoin.amos.latentdanger.dao.entity.MsgSubscribe;

public interface IMsgSubscribeService {
	public List<MsgSubscribe> queryMsgSubscribes(String orgCode, String userId);
	
	public List<MsgSubscribe> queryMsgSubscribes(String userId);

	public void saveSubscribe(List<MsgSubscribe> subscribe);
	
	/**
	 * 根据登陆用户获取未读消息数
	 * @param user
	 * @return
	 */
	public int getUnreadCount(AgencyUserModel user);
	
	/**
	 * 根据条件获取用户消息列表
	 * @param criterias
	 * @param commonPageable
	 * @return
	 */
	public Page<Msg> queryMsgList(List<DaoCriteria> criterias,CommonPageable commonPageable);
	
	/**
	 * 修改消息为已读
	 * @param msgId
	 * @return
	 */
	public Msg isRead(long msgId);
}
