package com.yeejoin.amos.latentdanger.core.async;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

import java.util.concurrent.Executor;

/**
 * @author DELL
 */
@Configuration(value = "taskExecutorPoolConfig")
public class TaskExecutorPoolConfig {
	@Bean("asyncTaskExecutor")
    public Executor taskExecutor() {
		ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
		//线程池维护线程的最少数量
		executor.setCorePoolSize(10);
		//线程池维护线程的最大数量
		executor.setMaxPoolSize(100);
		executor.setQueueCapacity(100);
		//线程池维护线程所允许的空闲时间,TimeUnit.SECONDS
		executor.setKeepAliveSeconds(30);
		executor.setThreadNamePrefix("asyncTaskExecutor-");
        return executor;
    }
}
