package com.yeejoin.amos.maintenance.business.dao.mapper;

import com.yeejoin.amos.maintenance.business.param.InputItemPageParam;
import com.yeejoin.amos.maintenance.business.vo.InputItemVo;
import com.yeejoin.amos.maintenance.business.vo.PointInputItemVo;
import com.yeejoin.amos.maintenance.dao.entity.InputItem;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Repository
public interface InputItemMapper {
    void updateInputItem(InputItem item);

    List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

    long countInputItemInfoData(InputItemPageParam param);

    List<InputItemVo> getInputItemInfo(InputItemPageParam param);

    List<InputItemVo> getInputItemListByNames(@Param("itemNames") String[] items, @Param("orgCode") String orgCode);

    List<PointInputItemVo> queryCustomInputItem(Map<String, Object> param);

    List<InputItemVo> getInputItemListByitemNos(@Param("itemNos") String[] itemNos);

    List<InputItem> getInputItemByEquipmentName(@Param("equipmentName") String equipmentName, @Param("orgCode") String orgCode);

    List<PointInputItemVo> queryCustomInputItemByPointId(@Param("pointId") Long pointId, @Param("equipmentId") String equipmentName);

    Integer insertList(List<InputItem> list);

    List<Map<String, Object>> queryInputItemInRountPoint(String routePointId);
}
