package com.yeejoin.amos.maintenance.business.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.yeejoin.amos.maintenance.business.vo.PointInputItemNewVo;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.maintenance.business.entity.mybatis.CheckPtListBo;
import com.yeejoin.amos.maintenance.business.param.CheckPtListPageParam;
import com.yeejoin.amos.maintenance.business.param.PointImportQueryParam;
import com.yeejoin.amos.maintenance.business.vo.LeavelMovePointVo;
import com.yeejoin.amos.maintenance.business.vo.PointInputItemVo;
import com.yeejoin.amos.maintenance.business.vo.PointVo;
import com.yeejoin.amos.maintenance.core.common.response.PointResponse;
import com.yeejoin.amos.maintenance.dao.entity.PointPhoto;

public interface PointMapper extends BaseMapper {

	/**
	 * 根据点ID获取点的检查项
	 *
	 * @param pointId
	 * @param classifyId
	 * @return
	 */
	List<PointInputItemVo> getPointInputItemById(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long classifyId);

	/**
	 * 根据点ID获取点的检查项
	 *
	 * @param pointId
	 * @param classifyId
	 * @return
	 */
	List<PointInputItemVo> getPointInputItemById1(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long classifyId);

	/**
	 * 根据点ID获取点的检查项
	 *
	 * @param pointId
	 * @param classifyId
	 * @return
	 */
	List<PointInputItemNewVo> getPointEquipInputItemById(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long classifyId);

	List<PointInputItemVo> getPointClassInputItemById(@Param(value = "pointId") Long pointId);

	/**
	 * 根据点ID获取点图片信息
	 *
	 * @param pointId
	 * @return
	 */
	List<PointPhoto> getPointPhotoByPointId(@Param(value = "pointId") Long pointId);

	List<HashMap<String, Object>> countByCatalogId(HashMap<String, Object> paramMap);

	int getPointCountByCondition(HashMap<String, Object> param);

	List<PointVo> getPointByCondition(HashMap<String, Object> param);

	Map<String, Object> getPointById(@Param(value = "pointId")  Long id);

	List<Map<String, Object>> getPointInputItem(@Param(value = "pointId") Long id);

	List<Map<String, Object>> getPointRoute(@Param(value = "pointId") Long id);

	List<Map<String, Object>> getPointClassify(@Param(value = "pointId") Long id);

	List<HashMap<String, Object>> getPointInputClassifyInfo(@Param(value = "pointId") Long id);

	List<HashMap<String, Object>> getSumPtForDept(@Param(value = "orgCode") String loginOrgCode);

	List<HashMap<String, Object>> getSumPtForAdmin(@Param(value = "orgCode") String orgCode);

	long getCheckPointCount(CheckPtListPageParam param);

	List<CheckPtListBo> getCheckPointList(CheckPtListPageParam param);
    /**
     * 巡检点明细查询
     * @param param
     * @return
     */
	CheckPtListBo getCheckPointById(@Param(value = "pointId")  int pointID);

	HashMap<String, Object> queryPointPie(HashMap<String, Object> params);
	List<HashMap<String, Object>> queryPointHistogram(HashMap<String, Object> params);

	long getPointCountByOrgCode(@Param("orgCode") String loginOrgCode);

	/**
	 * 获取巡检点使用信息
	 * @param id
	 * @return
	 */
	List<Map<String, Object>> getPointInfoById(@Param(value = "pointId") Long id);

	/**
	 * 同步离线移动巡检点信息
	 * @param orgCode
	 * @param startTime
	 * @return
	 */
	List<LeavelMovePointVo> queryLeavelPoint(@Param(value = "orgCode")String orgCode, @Param(value = "startTime") String startTime);

	List<Map<String, Object>> getPoints();

	List<Map<String, Object>> queryPointClassifyByRouteIdAndPointId(@Param(value = "routeId")Long routeId, @Param(value = "pointId") Long pointId);

	List<PointResponse> getPointConfigDom();

	List<PointVo> getPointVoByIds(PointImportQueryParam pointImportQueryParam);

	List<PointVo> getPointVoByOrgCode(@Param(value ="orgCode")String orgCode);

	List<HashMap<String, Object>> findPointList(@Param(value = "orgCode")String orgCode,@Param(value = "name")String name,@Param(value = "code")String code);

	Map<String, Object> getPointInputItem1(@Param(value = "pointId") Long id,@Param(value = "inputitemId") Long inputitemId);

	List<Map<String, Object>> queryAllPointConfig(String loginOrgCode);

	List<Map<String, Object>>  queryEquipPointInputItem(Long pointId);

	int queryPointCount4Route(@Param(value = "structureIdList") List<Long> structureIdList, @Param(value = "pointNo") String pointNo, @Param(value = "name") String name, @Param(value = "nullRiskSourceId") boolean nullRiskSourceId);

	List<Map<String, Object>> queryPointList4Route(@Param(value = "structureIdList") List<Long> structureIdList, @Param(value = "pointNo") String pointNo, @Param(value = "name") String name,
												   @Param(value = "offset") int offset, @Param(value = "size") int size, @Param(value = "nullRiskSourceId") boolean nullRiskSourceId);


	List<Map<String, Object>> queryPointListByRouteId(@Param(value = "routeId") Long routeId);

	List<Map<String, Object>> queryEquipListByPointId(@Param(value = "pointId") Long pointId);

    List<Map<String, Object>> queryItemList4RoutePoint(@Param(value = "pointId") Long pointId, @Param(value = "classifyId") Long equipId);

	/**
	 * 查询巡检点与巡查项对应关系
	 * @param list 点ID列表
	 */
	List<Map<String, Object>> getPointRefItem(List<Long> list);
}
