package com.yeejoin.amos.maintenance.business.dao.repository;

import com.yeejoin.amos.maintenance.dao.entity.PlanTaskDetail;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("planTaskDetail")
public interface IPlanTaskDetailDao extends BaseDao<PlanTaskDetail, Long> {

    @Modifying
    @Transactional
    @Query(value = "DELETE FROM p_plan_task_detail WHERE point_id IN (?1)", nativeQuery = true)
    void deletePlanTaskDetailByPointId(List<Long> pointIds);

    /**
     * 根据任务id及状态获取计划详情
     *
     * @param planTaskId
     * @return
     */
    List<PlanTaskDetail> findAllByTaskNoAndStatus(Long planTaskId, String status);

    int countByIsFinishAndTaskNo(int status, Long taskNo);

    @Modifying
    @Transactional
    @Query(value = "DELETE FROM p_plan_task_detail WHERE task_no IN (?1)", nativeQuery = true)
    void deletePlanTaskDetailByTaskNo(List<Long> planTaskNo);

    @Query(value = "select * FROM p_plan_task_detail WHERE point_id IN (?1)", nativeQuery = true)
    List<PlanTaskDetail> findALLByPointId(Long pointId);

    List<PlanTaskDetail> findByPointId(long pointId);

    @Query(value = "select id FROM p_plan_task_detail WHERE task_no = ?1 limit 1", nativeQuery = true)
    Long findIdByTaskNo(Long taskNo);
}