package com.yeejoin.amos.maintenance.business.service.impl;

import com.yeejoin.amos.maintenance.business.dao.repository.IPointDao;
import com.yeejoin.amos.maintenance.business.service.intfc.IPointService;
import com.yeejoin.amos.maintenance.business.service.intfc.ISynDataService;
import com.yeejoin.amos.maintenance.dao.entity.BasicEntity;
import com.yeejoin.amos.maintenance.dao.entity.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author DELL
 */
@Service
public class SynDataServiceImpl implements ISynDataService {

    @Autowired
    IPointService iPointService;
    @Autowired
    IPointDao iPointDao;


    @Override
    public List<Long> pointDelete(String ids) {
        List<String> idList = Arrays.stream(ids.split(",")).collect(Collectors.toList());
        List<Point> points = iPointDao.listByOriginalIds(idList);
        List<Long> pointIds = points.stream().map(BasicEntity::getId).collect(Collectors.toList());
        Long[] sds = pointIds.toArray(new Long[0]);
        if (sds.length > 0) {
            return iPointService.delPointById(sds);
        }
        return pointIds;
    }
}
