package com.yeejoin.amos.patrol.business.dto;

import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.StringUtils;

import java.util.Date;

@Data
public class ExcelDto {
	@ApiModelProperty(value = "文件名称")
    private String fileName;
    @ApiModelProperty(value = "sheet页名称")
    private String sheetName;
    @ApiModelProperty(value = "类包全路径")
    private String classUrl;
    @ApiModelProperty(value = "导出类型 来源于ExcelEnums常量")
    private String type;

    public ExcelDto(String fileName, String sheetName, String classUrl, String type) {
        super();
        this.fileName = fileName;
        this.sheetName = sheetName;
        this.classUrl = classUrl;
        this.type = type;
    }

    public ExcelDto(String fileName, String sheetName, String type) {
        this.fileName = fileName;
        this.sheetName = sheetName;
        this.type = type;
    }

    public ExcelDto() {

    }

    public String getFileName() {
        return StringUtils.isEmpty(fileName) ? DateUtils.convertDateToString(new Date(), "yyyyMMddHHmmss") : fileName;
    }

    public String getSheetName() {
        return StringUtils.isEmpty(sheetName) ? "Sheet1" : sheetName;
    }
}
