package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.service.IBadManagementService;
import com.yeejoin.precontrol.common.vo.BadManagementVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@Api(tags = " 分包商违章Api")
@RequestMapping(value = "/badManagement", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class BadManagementController {
    @Autowired
    IBadManagementService IBadManagementService;

    @ApiOperation(httpMethod = "GET", value = "根据公司ID分页查询违章信息")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public Page<BadManagementVo> pageList(Long pageNum, Long pageSize, String companyId) {
        return IBadManagementService.pageList(pageNum, pageSize, companyId);
    }
}
