package com.yeejoin.precontrol.controller;

import com.yeejoin.precontrol.common.service.IPersonWorkingHoursService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 工时信息
 *
 * @author duanwei
 * @date 2020-06-30
 */
@RestController
@Api(tags = "工时信息Api")
@RequestMapping(value = "/person-working-hours", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class PersonWorkingHoursController {

    /**
     * 工时服务
     */
    @Autowired
    IPersonWorkingHoursService iPersonWorkingHoursService;

    @RequestMapping(value = "/workHourStatistical", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "人员工时统计", notes = "人员工时统计")
    public Object workHourStatisticalByPersonId(
            @RequestParam(value = "personId", required = true) Long personId,
            @RequestParam(value = "curTime", required = false) String curTime) {
        return iPersonWorkingHoursService.workHourStatisticalByPersonId(personId, curTime);
    }



}
