package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.RiskWorkMeasure;
import com.yeejoin.precontrol.common.service.IRiskWorkMeasureService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;


/**
 * 管控措施
 *
 * @author duanwei
 * @date 2021-01-28
 */
@RestController
@Api(tags = "管控措施Api")
@RequestMapping(value = "/risk-work-measure", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class RiskWorkMeasureController {

    @Autowired
    IRiskWorkMeasureService iRiskWorkMeasureService;


    /**
     * 新增管控措施
     *
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增管控措施", notes = "新增管控措施")
    public boolean saveRiskWorkMeasure(HttpServletRequest request, @RequestBody RiskWorkMeasure riskWorkMeasure) {
        return iRiskWorkMeasureService.save(riskWorkMeasure);
    }

    /**
     * 根据id删除
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkMeasureService.removeById(id);
    }


    /**
     * 修改管控措施
     *
     * @return
     */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改管控措施", notes = "修改管控措施")
    public boolean updateByIdRiskWorkMeasure(HttpServletRequest request, @RequestBody RiskWorkMeasure riskWorkMeasure) {
        return iRiskWorkMeasureService.updateById(riskWorkMeasure);
    }


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public RiskWorkMeasure selectById(HttpServletRequest request, @PathVariable Long id) {
        return iRiskWorkMeasureService.getById(id);
    }


    /**
     * 列表分页查询
     *
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<RiskWorkMeasure> listPage(String pageNum, String pageSize,
                                           RiskWorkMeasure riskWorkMeasure) {

        Page<RiskWorkMeasure> pageBean;
        QueryWrapper<RiskWorkMeasure> riskWorkMeasureQueryWrapper = new QueryWrapper<>();
        Class<? extends RiskWorkMeasure> aClass = riskWorkMeasure.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(riskWorkMeasure);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(riskWorkMeasure);
                        riskWorkMeasureQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(riskWorkMeasure);
                        riskWorkMeasureQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(riskWorkMeasure);
                        riskWorkMeasureQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(riskWorkMeasure);
                        riskWorkMeasureQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
            }
        });
        IPage<RiskWorkMeasure> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iRiskWorkMeasureService.page(pageBean, riskWorkMeasureQueryWrapper);
        return page;
    }
}


