package com.yeejoin.precontrol.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.TaskRiskControlTechDto;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.TaskPersonKnowledgeAttachment;
import com.yeejoin.precontrol.common.entity.TaskRiskControlTech;
import com.yeejoin.precontrol.common.service.IPersonService;
import com.yeejoin.precontrol.common.service.ITaskRiskControlTechService;
import com.yeejoin.precontrol.common.utils.NameUtils;
import com.yeejoin.precontrol.common.vo.TaskRiskControlTechVo;
import com.yeejoin.precontrol.controller.publics.BaseController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;

/**
 * 风险管控任务表
 *
 * @author duanwei
 * @date 2021-11-01
 */
@RestController
@Api(tags = "技术交底任务表Api")
@RequestMapping(value = "/task-risk-control-tech", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class TaskRiskControlTechController extends BaseController {

	@Autowired
	ITaskRiskControlTechService iTaskRiskControlTechService;

	@Autowired
	IPersonService iPersonService;

	/**
	 * 新增风险管控任务表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增风险管控任务表", notes = "新增风险管控任务表")
	public boolean saveTaskRiskControlTech(HttpServletRequest request,
			@RequestBody TaskRiskControlTech taskRiskControlTech) {
		return iTaskRiskControlTechService.save(taskRiskControlTech);
	}

	/**
	 * 根据id删除
	 * 
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iTaskRiskControlTechService.removeById(id);
	}

	/**
	 * 修改风险管控任务表
	 * 
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改风险管控任务表", notes = "修改风险管控任务表")
	public boolean updateByIdTaskRiskControlTech(HttpServletRequest request,
			@RequestBody TaskRiskControlTech taskRiskControlTech) {
		return iTaskRiskControlTechService.updateById(taskRiskControlTech);
	}

	/**
	 * 根据id查询
	 * 
	 * @param id
	 * @return2
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public TaskRiskControlTechVo selectById(HttpServletRequest request, @PathVariable Long id, Long taskPersonId) {
		Person person = getPerson();
		return iTaskRiskControlTechService.getDetailById(id, person.getId(), taskPersonId);
	}

	/**
	 * 列表分页查询
	 * 
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
	public IPage<TaskRiskControlTech> listPage(String pageNum, String pageSize,
			TaskRiskControlTech taskRiskControlTech) {

		Page<TaskRiskControlTech> pageBean;
		QueryWrapper<TaskRiskControlTech> taskRiskControlTechQueryWrapper = new QueryWrapper<>();
		Class<? extends TaskRiskControlTech> aClass = taskRiskControlTech.getClass();
		Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
			try {
				field.setAccessible(true);
				Object o = field.get(taskRiskControlTech);
				if (o != null) {
					Class<?> type = field.getType();
					String name = NameUtils.camel2Underline(field.getName());
					if (type.equals(Integer.class)) {
						Integer fileValue = (Integer) field.get(taskRiskControlTech);
						taskRiskControlTechQueryWrapper.eq(name, fileValue);
					} else if (type.equals(Long.class)) {
						Long fileValue = (Long) field.get(taskRiskControlTech);
						taskRiskControlTechQueryWrapper.eq(name, fileValue);
					} else if (type.equals(String.class)) {
						String fileValue = (String) field.get(taskRiskControlTech);
						taskRiskControlTechQueryWrapper.eq(name, fileValue);
					} else {
						String fileValue = (String) field.get(taskRiskControlTech);
						taskRiskControlTechQueryWrapper.eq(name, fileValue);
					}
				}
			} catch (Exception e) {
			}
		});
		IPage<TaskRiskControlTech> page;
		if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
			pageBean = new Page<>(0, Long.MAX_VALUE);
		} else {
			pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
		}
		page = iTaskRiskControlTechService.page(pageBean, taskRiskControlTechQueryWrapper);
		return page;
	}

	/**
	 * 获取我的风险预控列表
	 *
	 * @return
	 */
	@RequestMapping(value = "/myList", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "获取我的风险预控列表", notes = "获取我的风险预控列表")
	public Page<TaskRiskControlTechVo> createTask(@ApiParam(value = "分页条件 isAll=0 具体分页必传") CommonPageableDto pageable,
			@ApiParam(value = "查询参数") TaskRiskControlTechDto taskRiskControlTechDto, HttpServletResponse response) {
		Person person = iPersonService.getById(getPerson().getId());
		// 分包商只看自己的----userId;江西电建查看项目部的----orgCode
		if (person.getIsJxdj() == 0) {
			//taskRiskControl.setOrgCode("");
			taskRiskControlTechDto.setPersonId(person.getId());
		} else {
			taskRiskControlTechDto.setPersonId(person.getId());
			taskRiskControlTechDto.setOrgCode(person.getOrgCode());
		}
		return iTaskRiskControlTechService.myListByPage(pageable, person.getId(), taskRiskControlTechDto);
	}

	/**
	 * 新增风险管控任务表(江西电建)
	 *
	 * @return
	 */
	@RequestMapping(value = "/createTask", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增风险管控任务表", notes = "新增风险管控任务表")
	public TaskRiskControlTechVo createTask(HttpServletRequest request,
			@RequestBody TaskRiskControlTechVo taskRiskControlTechVo) {
		Person person = getPerson();
		taskRiskControlTechVo.setOrgCode(person != null ? person.getOrgCode() : null);
		taskRiskControlTechVo.setCreatePersonId(person.getId());
		TaskRiskControlTechVo riskControlVo = iTaskRiskControlTechService.createTask(taskRiskControlTechVo);
		// iTaskRiskControlTechService.taskRiskNotice(riskControlVo,
		// riskControlVo.getCompanyPersonId()); // 消息通知--给分包商主管发消息
		return riskControlVo;
	}

	/**
	 * 新增风险管控任务表(分包商)
	 *
	 * @return
	 */
	@RequestMapping(value = "/createTaskByFbs", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增风险管控任务表", notes = "新增风险管控任务表")
	public TaskRiskControlTechVo createTaskByFbs(HttpServletRequest request,
			@RequestBody TaskRiskControlTechVo taskRiskControlTechVo) {
		return iTaskRiskControlTechService.createTaskByFbs(taskRiskControlTechVo);
	}

	/**
	 * 下一步
	 *
	 * @return
	 */
	@RequestMapping(value = "/next", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增风险管控任务表", notes = "新增风险管控任务表")
	public TaskRiskControlTechVo next(HttpServletRequest request,
			@RequestBody TaskRiskControlTechVo taskRiskControlTechVo) {
		return iTaskRiskControlTechService.nextStage(taskRiskControlTechVo);
	}

	/**
	 * 阅读文件
	 *
	 * @return
	 */
	@RequestMapping(value = "/doDocument", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "检查", notes = "检查")
	public TaskRiskControlTechVo doDocument(HttpServletRequest request,
			@RequestBody TaskRiskControlTechVo taskRiskControlTechVo) {
		return iTaskRiskControlTechService.doDocument(taskRiskControlTechVo);
	}
	

	/**
	 * 阅读文件
	 *
	 * @return
	 */
	@RequestMapping(value = "/doDocumentAttach", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "检查", notes = "检查")
	public TaskRiskControlTechVo doDocumentAttach(HttpServletRequest request,
			@RequestBody TaskPersonKnowledgeAttachment attachment) {
		return iTaskRiskControlTechService.doDocumentAttach(attachment.getId());
	}

	/**
	 * 确认任务
	 *
	 * @return
	 */
	@RequestMapping(value = "/confirm", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "检查", notes = "检查")
	public TaskRiskControlTechVo confirm(HttpServletRequest request,
			@RequestBody TaskRiskControlTechVo taskRiskControlTechVo) {
		Person person = getPerson();
		return iTaskRiskControlTechService.confirm(taskRiskControlTechVo);
	}

	/**
	 * 施工方案查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/construct-list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "POST", value = "检查", notes = "检查")
	public Page<TaskRiskControlTechVo> constructList(CommonPageableDto pageable,
			TaskRiskControlTechDto taskRiskControlTechDto) {
		Person person = getPerson();
		taskRiskControlTechDto.setPersonId(person!=null?person.getId():null);
		taskRiskControlTechDto.setIsJxdj(person.getIsJxdj());
		return iTaskRiskControlTechService.constructList(pageable,taskRiskControlTechDto);
	}
}
