package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.HiddenDanger;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository("iHiddenDangerDao")
public interface IHiddenDangerDao extends BaseDao<HiddenDanger, Long> {
    /**
     * 按照唯一索引查询
     *
     * @param latentDangerId 隐患模块id
     * @return HiddenDanger
     */
    HiddenDanger findByLatentDangerId(Long latentDangerId);

    /**
     * 查询批量
     * @param ids 隐患ids
     * @return List<HiddenDanger>
     */
    List<HiddenDanger> findByLatentDangerIdIn(List<Long> ids);


    /**
     * 根据ids删除
     * @param ids
     */
    @Modifying
    @Transactional
    @Query(value="DELETE FROM p_hidden_danger WHERE latent_danger_id IN (?1)", nativeQuery = true)
    void deleteByDangerIdIn(List<Long> ids);

    /**
     * 根据计划id获取列表
     * @param planId 计划id
     * @return 隐患关系列表
     */
    List<HiddenDanger> findByPlanId(Long planId);
}
