package com.yeejoin.amos.supervision.business.dao.repository;

import com.yeejoin.amos.supervision.dao.entity.PlanAuditLog;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("planAuditLogDao")
public interface IPlanAuditLogDao extends BaseDao<PlanAuditLog, Long> {

    /**
     * 指定计划的审核日志
     * @param planId 计划id
     * @param sort 排序条件
     * @return List<PlanAuditLog>
     */
    List<PlanAuditLog> findAllByPlanId(Long planId, Sort sort);
}