package com.yeejoin.amos.supervision.business.entity.mybatis;

import com.yeejoin.amos.supervision.business.entity.mybatis.extend.TaskworkExtend;
import lombok.Data;

import java.util.Date;

/**
 * 作业活动
 */
@Data
public class TaskworkBo extends TaskworkExtend {

    /**
     * 主键编号
     */
    private Long id;

    /**
     * 作业活动名称
     */
    private String name;

    /**
     * 类型
     */
    private String type;

    /**
     * 岗位
     */
    private String post;

    /**
     * 部位
     */
    private String part;

    /**
     * 所在分区
     */
    private String regionId;

    /**
     * 部门
     */
    private String departmentId;

    /**
     * 班组
     */
    private String groupId;
    
    /**
     * 违章状态:默认1；1-无违章；2-一般违章；3-严重违章
     */
    private Long violateState;

    /**
     * 作业活动状态（0：未启动；1：待班组审核；2：待车间/部门审核；3：待公司审核；4：待执行；5：待确认验收；6：完成）
     */
    private Integer status;

    /**
     * 风险等级id
     */
    private Long riskLevelId;

    /**
     * 创建人
     */
    private String creatorId;

    /**
     * 是否被监控
     */
    private Boolean isMonitor;

    /**
     * 组织编码
     */
    private String orgCode;

    /**
     * 当前工作流记录编号
     */
    private Long currentFlowRecordId;

    /**
     * 工作流实例编号
     */
    private String instanceId;

    private String businessKey;

    /**
     * 申请人
     */
    private String applyUserId;

    /**
     * 申请人部门编号
     */
    private String applyDepartmentId;

    /**
     * 申请时间
     */
    private Date applyDate;

    /**
     *
     */
    private Date createDate;

    /**
     * 修改时间
     */
    private Date updateDate;

}
