package com.yeejoin.amos.supervision.business.service.intfc;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.supervision.dao.entity.PlanAuditLog;

import java.util.List;
import java.util.Map;

public interface IPlanAuditService {
    Boolean auditWorkFlow(PlanAuditLog planAuditLog, Integer status, String condition, ReginParams reginParams) throws Exception;

    /**
     * 查询指定计划的审批日志
     * @param planId 计划id
     * @return List<PlanAuditLog>
     */
    List<PlanAuditLog> listByPlanId(Long planId);

    /**
     * 登陆人是否有该计划执行权限
     * @param planId 计划id
     * @param reginParams 登陆人信息
     * @return 权限标识
     */
    Map<String, Object> checkTaskAuth(Long planId, ReginParams reginParams);
}
