package com.yeejoin.amos.supervision.business.util;

import com.yeejoin.amos.supervision.business.param.PlanInfoPageParam;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;

import java.util.HashMap;
import java.util.List;

public class PlanPageParamUtil {

	public static PlanInfoPageParam fillPlanInfoParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
                                                      HashMap<String, Object> perMap) {
		PlanInfoPageParam param = new PlanInfoPageParam();
		for(int i=0;i<queryRequests.size();i++){
			String name = queryRequests.get(i).getName();
			if("name".equals(name)){
				param.setPlanName(toString(queryRequests.get(i).getValue()));
			}else if("planType".equals(name)){
				param.setPlanType(toString(queryRequests.get(i).getValue()));
			}else if("routeId".equals(name)){
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			}else if("remark".equals(name)){
				param.setRemark(toString(queryRequests.get(i).getValue()));
			}else if("ownerId".equals(name)){
				param.setOwnerId(toString(queryRequests.get(i).getValue()));
			}else if("planStatus".equals(name)){
				param.setPlanStatus(toString(queryRequests.get(i).getValue()));
			}else if("leadPerson".equals(name)){
				param.setLeadPerson(toString(queryRequests.get(i).getValue()));
			}else if("checkTypeId".equals(name)){
				param.setCheckTypeId(toString(queryRequests.get(i).getValue()));
			}
		}		
		param.setOrgCode(perMap.get("orgCode") == null ? null:perMap.get("orgCode").toString());
		param.setDeptId(perMap.get("deptId") == null ? null:perMap.get("deptId").toString());
		param.setUserId(perMap.get("userId") == null ? null:perMap.get("userId").toString());
		if(commonPageable !=null){
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());	
		}
		return param;
	}
	
	private static String toString(Object value) {
		if(null ==value || value ==""){
			return null;
		}else{
			return value.toString();
		}		
	}

}
