package com.yeejoin.amos.supervision.feign;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.DepartmentBo;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import com.yeejoin.amos.component.feign.config.TokenOperation;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.*;
import com.yeejoin.amos.feign.privilege.util.DesUtil;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.amos.supervision.business.feign.JCSFeignClient;
import com.yeejoin.amos.supervision.business.util.CommonResponse;
import com.yeejoin.amos.supervision.business.util.Toke;
import com.yeejoin.amos.supervision.common.remote.IAMOSSecurityServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Service("remoteSecurityService")
public class RemoteSecurityService {
    @Value("${security.password}")
    private String password;
    @Value("${security.loginId}")
    private String loginId;
    @Value("${security.productWeb}")
    private String productWeb;
    @Value("${security.appKey}")
    private String appKey;
    @Value("${security.productApp}")
    private String productApp;

    private static final Logger log = LoggerFactory.getLogger(RemoteSecurityService.class);

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private IAMOSSecurityServer iAmosSecurityServer;

    @Autowired
    private JCSFeignClient jcsFeignClient;

    //根据公司名称获取公司人
    public List<CompanyModel> listCompanyTree(String toke, String product, String appKey, String companyName) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<CompanyModel> userModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.queryAgencyTree(companyName);
            userModel = (List<CompanyModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return userModel;
    }

    public List<AgencyUserModel> listUserByMenuCode(String permissionType, String path) {
        CommonResponse commonResponse = iAmosSecurityServer.listUserByMenuCode(permissionType, path);
        return handleArray(commonResponse, AgencyUserModel.class);
    }

    public List<AgencyUserModel> listUserByMenuCode(String token, String product, String appKey, String permissionType, String path) {
        CommonResponse commonResponse = iAmosSecurityServer.listUserByMenuCode(permissionType, path);
        return handleArray(commonResponse, AgencyUserModel.class);
    }

    public JSONArray getMenuPathByUserIdAndPermissionType(String userId, String permissionType) {
        CommonResponse commonResponse = iAmosSecurityServer.getMenuPathByUserIdAndPermissionType(userId, permissionType);
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr);
        }
        return null;
    }

    public Toke getServerToken() {
        IdPasswordAuthModel dPasswordAuthModel = new IdPasswordAuthModel();
        dPasswordAuthModel.setLoginId(loginId);
        dPasswordAuthModel.setPassword(DesUtil.encode(password, "qaz"));
        Toke toke = null;
        try {
            toke = JSON.parseObject(redisTemplate.opsForValue().get(buildKey(loginId)), Toke.class);
            if (ObjectUtils.isEmpty(toke)) {
                toke = getLogin(dPasswordAuthModel);
            } else {
            	RequestContext.setProduct(productWeb);
                if (!TokenOperation.refresh(toke.getToke())) {
                    toke = getLogin(dPasswordAuthModel);
                }
            }
        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return toke;
    }

    private Toke getLogin(IdPasswordAuthModel dPasswordAuthModel) {
        Toke toke = new Toke();
        RequestContext.setProduct(productWeb);
        System.out.println("================================supervision");
        FeignClientResult feignClientResult = Privilege.authClient.idpassword(dPasswordAuthModel);
        Map map = (Map) feignClientResult.getResult();
        if (map != null) {
            toke.setToke(map.get("token").toString());
            toke.setProduct(productWeb);
            toke.setAppKey(appKey);
            redisTemplate.opsForValue().set(buildKey(dPasswordAuthModel.getLoginId()), JSONObject.toJSONString(toke), 28, TimeUnit.DAYS);
        }
        return toke;
    }


    //redi缓存系统用户token信息
    private String buildKey(String username) {
        return "system_" + username;

    }

    //部门id获取部门信息
    public DepartmentModel getDepartmentByDeptId(String toke, String product, String appKey, String deparmentId) {
        if (deparmentId == null || deparmentId.equals("")) {
            return null;
        }
        // CommonResponse commonResponse = iAmosSecurityServer.getDepartmentByDeptId(deparmentId);
        // return handleObj(commonResponse, DepartmentBo.class);

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        DepartmentModel departmentModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.departmentClient.seleteOne(Long.valueOf(deparmentId));
            departmentModel = (DepartmentModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return departmentModel;
    }

    //查询指定部门数
    public List<DepartmentModel> listDepartmentsByCompanyId(String toke, String product, String appKey, String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<DepartmentModel> departmentModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.departmentClient.queryDeptTree(null, Long.valueOf(companyId));
            departmentModel = (List<DepartmentModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return departmentModel;

        //CommonResponse commonResponse = iAmosSecurityServer.listDepartmentsByCompanyId(companyId);
        //return handleArray(commonResponse, DepartmentBo.class);
    }

    // * 根据公司id查询机构用户
    public List<AgencyUserModel> listUserByCompanyId(String toke, String product, String appKey, String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<AgencyUserModel> AgencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByCompanyId(Long.valueOf(companyId), null, null, true);
            AgencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return AgencyUserModel;
    }

    // * 根据公司RoleIds
    public List<AgencyUserModel> getUserByRoleIds(String toke, String product, String appKey, String RoleIds) {
        if (RoleIds == null || RoleIds.equals("")) {
            return null;
        }

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByRoleId(RoleIds, null);
            agencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }

    //用户id批量获取用户信息
    public List<AgencyUserModel> listUserByUserIds(String toke, String product, String appKey, String userIds) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByIds(userIds, null);
            agencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }

    public List<AgencyUserModel> listUserByUserIds(String userIds) {
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByIds(userIds, null);
            agencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }

    public AgencyUserModel getUserById(String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        CommonResponse commonResponse = iAmosSecurityServer.getUserById(userId);
        return handleObj(commonResponse, AgencyUserModel.class);
    }

    public DepartmentBo getDepartmentByDeptId(String deparmentId) {
        if (deparmentId == null || deparmentId.equals("")) {
            return null;
        }
        CommonResponse commonResponse = iAmosSecurityServer.getDepartmentByDeptId(deparmentId);
        return handleObj(commonResponse, DepartmentBo.class);
    }

    public List<DepartmentBo> listDepartmentByDeptIds(String departmentIds) {
        CommonResponse commonResponse = iAmosSecurityServer.listDepartmentByDeptIds(departmentIds);
        return handleArray(commonResponse, DepartmentBo.class);
    }

    public List<DepartmentBo> getDepartmentTreeByCompanyId(String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        CommonResponse commonResponse = iAmosSecurityServer.getDepartmentTreeByCompanyId(companyId);
        return handleArray(commonResponse, DepartmentBo.class);
    }

    public List<CompanyBo> listCompanyTree() {
        CommonResponse commonResponse = iAmosSecurityServer.listCompanyTree();
        return handleArray(commonResponse, CompanyBo.class);
    }


    //用户id获取用户信息
    public AgencyUserModel getUserById(String toke, String product, String appKey, String userId) {
        if (userId == null || userId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        AgencyUserModel agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByUserId(userId);
            agencyUserModel = (AgencyUserModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }

    //根据orgCode查询机构用户
    public List<AgencyUserModel> listUserByOrgCode(String toke, String product, String appKey, String orgCode) {
        if (orgCode == null || orgCode.equals("")) {
            return null;
        }

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByOrgCode(orgCode, null);
            HashSet<AgencyUserModel> agencyUserModelSet = (HashSet<AgencyUserModel>) feignClientResult.getResult();
            agencyUserModel = new ArrayList<AgencyUserModel>(agencyUserModelSet);

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }


    //根据orgCode查询机构
    public Map<String, Object> listByOrgCode(String toke, String product, String appKey, String orgCode) {
        if (orgCode == null || orgCode.equals("")) {
            return null;
        }

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        Map<String, Object> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.queryByOrgcode(orgCode);
            agencyUserModel = (Map<String, Object>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }


    // 根据部门id查询机构用户
    public List<AgencyUserModel> listUserByDepartmentId(String toke, String product, String appKey, String departmentId) {
        if (departmentId == null || departmentId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<AgencyUserModel> agencyUserModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.queryByDepartmentId(Long.valueOf(departmentId), null, null, null);
            agencyUserModel = (List<AgencyUserModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return agencyUserModel;
    }

    //* 获取子公司信息树结构
    public List<CompanyModel> getCompanyTreeByCompanyId(String toke, String product, String appKey, String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<CompanyModel> companyModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.querySubAgencyTree(Long.valueOf(companyId));
            companyModel = (List<CompanyModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return companyModel;
    }

    //查询指定公司的部门树
    public List<DepartmentModel> getDepartmentTreeByCompanyId(String toke, String product, String appKey, String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<DepartmentModel> departmentModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.departmentClient.queryDeptTree(null, Long.valueOf(companyId));
            departmentModel = (List<DepartmentModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return departmentModel;
    }

    //根据id批量获取部门信息
    public List<LinkedHashMap> listDepartmentByDeptIds(String toke, String product, String appKey, String departmentIds) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<LinkedHashMap> departmentModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.departmentClient.queryDeptByIds(departmentIds);
            departmentModel = (List<LinkedHashMap>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return departmentModel;
    }

    private <T> List<T> handleArray(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONArray.parseArray(jsonStr, t);
        }
        return null;
    }

    private <T> T handleObj(CommonResponse commonResponse, Class<T> t) {
        if (commonResponse != null && commonResponse.isSuccess()) {
            String jsonStr = JSON.toJSONString(commonResponse.getDataList());
            return JSONObject.parseObject(jsonStr, t);
        }
        return null;
    }

    /**
     * 基础平台全部菜单权限树,用于平台登录前端初始化路由
     */
    public CommonResponse searchPermissionTree(String toke, String product, String appKey, String appType) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<PermissionModel> dictionarieModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.permissionClient.queryPermissionTree(appType, null, null, null, null);
            dictionarieModel = (List<PermissionModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        CommonResponse commonResponse = new CommonResponse("SUCCESS", dictionarieModel);


        return commonResponse;


    }

    public JSONArray getMenuPathByUserIdAndPermissionType(String toke, String product, String appKey, String userId, String permissionType) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        Object dictionarieModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.permissionClient.queryPathForListByUser(permissionType, null, userId);
            dictionarieModel = feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        if (dictionarieModel != null) {
            String jsonStr = JSON.toJSONString(dictionarieModel);
            return JSONArray.parseArray(jsonStr);
        }
        return null;
    }

    //根据Code查询指定的字典信息.
    public JSONArray listDictionaryByDictCode(String toke, String product, String appKey, String dictCode) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<DictionarieValueModel> dictionarieModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Systemctl.dictionarieClient.dictValues(dictCode);
            dictionarieModel = (List<DictionarieValueModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        if (dictionarieModel != null) {
            String jsonStr = JSON.toJSONString(dictionarieModel);
            return JSONArray.parseArray(jsonStr);
        }
        return null;
    }

    /**
     * 查询指定公司信息与其部门用户树
     */
    public CompanyModel listUserByCompanyId1(String toke, String product, String appKey, String companyId) {
        if (companyId == null || companyId.equals("")) {
            return null;
        }
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        CompanyModel companyModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.withDeptAndUsers(Long.valueOf(companyId));
            companyModel = (CompanyModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return companyModel;

    }


    public JSONObject loginFromApp(String userName, String password) {
        IdPasswordAuthModel dPasswordAuthModel = new IdPasswordAuthModel();
        dPasswordAuthModel.setLoginId(userName);
        dPasswordAuthModel.setPassword(DesUtil.decode(password, "yeejoin"));
        Map map = null;
        FeignClientResult feignClientResult = new FeignClientResult();
        RequestContext.setProduct(productApp);
        Toke oked = new Toke();
        try {
            System.out.println("================================supervision2");
            feignClientResult = Privilege.authClient.idpassword(dPasswordAuthModel);
            map = (Map) feignClientResult.getResult();
            map.put("appKey", appKey);
            map.put("product", productApp);
        } catch (InnerInvokException e) {
            e.printStackTrace();
        }

        if (map != null) {
            String jsonStr = JSON.toJSONString(map);
            return JSONObject.parseObject(jsonStr);
        }
        return null;
    }

    public boolean loginOutFromApp(String toke, String product, String appKey) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        boolean flag = false;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.authClient.removeToken();
            flag = true;
        } catch (InnerInvokException e) {
            e.printStackTrace();
        }

        return flag;
    }

    public JSONArray listDepartmentUserTree(String toke, String product, String appKey, String companyId) {

        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        CompanyModel companyModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.companyClient.withDeptAndUsers(Long.valueOf(companyId));
            companyModel = (CompanyModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }

        if (companyModel != null) {
            String jsonStr = null;

            jsonStr = JSON.toJSONString(companyModel.getChildren());

            return JSONArray.parseArray(jsonStr);
        }
        return null;
    }

    public boolean editPassword(String toke, String product, String appKey, String userId, String oldPassword, String newPassword) {
        boolean flag = false;
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        AgencyUserModel agencyUserModel = new AgencyUserModel();
        agencyUserModel.setPassword(newPassword);
        agencyUserModel.setRePassword(newPassword);
        agencyUserModel.setOriginalPassword(oldPassword);

        AgencyUserModel agencyUserModel2 = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.agencyUserClient.modifyPassword(userId, agencyUserModel);

            agencyUserModel2 = (AgencyUserModel) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        if (agencyUserModel2 != null) {
            flag = true;
        }
        return flag;
    }

    public AgencyUserModel getAgencyUserModel(String token) {
        RequestContext.setToken(token);
        RequestContext.setAppKey(appKey);
        RequestContext.setProduct(productWeb);
        try {
            AgencyUserModel result = Privilege.agencyUserClient.getme().getResult();
            return result;
        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 基础平台全部菜单权限树,用于平台登录前端初始化路由
     */
    public CommonResponse searchPermissionTree(long id, String toke, String product, String appKey, String appType) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        List<PermissionModel> dictionarieModel = null;
        FeignClientResult feignClientResult;
        try {
            feignClientResult = Privilege.permissionClient.treeByRole(id, appType, null, null);
            dictionarieModel = (List<PermissionModel>) feignClientResult.getResult();

        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        CommonResponse commonResponse = new CommonResponse("SUCCESS", dictionarieModel);
        return commonResponse;
    }


    /**
     * 根据用户ids获取用户实体列表
     *
     * @param toke
     * @param product
     * @param appKey
     * @param userIds
     * @return
     */
    public Map<String, AgencyUserModel> getUsersMap(String toke, String product, String appKey, Set<Object> userIds) {
        List<AgencyUserModel> users = listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        Map<String, AgencyUserModel> userMap = new HashMap<>();
        if (users != null) {
            userMap = users.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, v -> v, (v1, v2) -> v1));
        }
        return userMap;
    }

    /**
     * 根据用户ids获取用户名称列表
     *
     * @param toke
     * @param product
     * @param appKey
     * @param userIds
     * @return
     */
    public Map<String, String> getUserRealName(String toke, String product, String appKey, Set<Object> userIds) {
        List<AgencyUserModel> users = listUserByUserIds(toke, product, appKey, Joiner.on(",").join(userIds));
        Map<String, String> userMap = new HashMap<>();
        if (users != null) {
            userMap = users.stream().collect(Collectors.toMap(AgencyUserModel::getUserId, AgencyUserModel::getRealName));
        }
        return userMap;
    }

    /**
     * 根据部门ids获取部门名称
     *
     * @param toke
     * @param product
     * @param appKey
     * @param depIds
     * @return
     */
    public Map<Long, String> getDepName(String toke, String product, String appKey, Set<Object> depIds) {
        List<DepartmentModel> depts = new ArrayList<>();
        if (!CollectionUtils.isEmpty(depIds)) {
            depts = this.getlistDepartmentByDeptIds(toke, product, appKey, Joiner.on(",").join(depIds));
        }
        Map<Long, String> deptMap = new HashMap<>();
        if (depts != null) {
            deptMap = depts.stream().collect(Collectors.toMap(DepartmentModel::getSequenceNbr, DepartmentModel::getDepartmentName));
        }
        return deptMap;
    }

    /**
     * 根据id批量获取部门信息
     *
     * @param toke                                                     token
     * @param product                                                  product
     * @param appKey                                                   appKey
     * @param "200".equals(feignClientResult.getStatus())departmentIds 部门ids
     * @return List<DepartmentModel>
     */
    public List<DepartmentModel> getlistDepartmentByDeptIds(String toke, String product, String appKey, String departmentIds) {
        RequestContext.setToken(toke);
        RequestContext.setProduct(product);
        RequestContext.setAppKey(appKey);
        FeignClientResult feignClientResult = new FeignClientResult();
        try {
            feignClientResult = Privilege.departmentClient.queryDeptByIds(departmentIds);
        } catch (InnerInvokException e) {
            e.printStackTrace();
        }
        return handleArray(feignClientResult, DepartmentModel.class);
    }

    private <T> List<T> handleArray(FeignClientResult feignClientResult, Class<T> t) {
        List<T> list = new ArrayList<>();
        if (feignClientResult != null && feignClientResult.getStatus() == 200) {
            String jsonStr = JSON.toJSONString(feignClientResult.getResult());
            list = JSONArray.parseArray(jsonStr, t);
        }
        return list;
    }

}


