package com.yeejoin.amos.boot.module.cas.controller;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.cas.api.dto.IdxBizXnzsDto;
import com.yeejoin.amos.boot.module.cas.api.dto.ResultDto;
import com.yeejoin.amos.boot.module.cas.api.entity.IdxBizXnzs;
import com.yeejoin.amos.boot.module.cas.api.service.IIdxBizXnzsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;


/**
 * 
 *
 * @author duanwei
 * @date 2022-09-14
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/idx-biz-xnzs", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class IdxBizXnzsController  extends BaseController {

  @Autowired
  IIdxBizXnzsService iIdxBizXnzsService;


    /**
    * 新增
    * @return
    */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public boolean saveIdxBizXnzs(HttpServletRequest request, @RequestBody IdxBizXnzs idxBizXnzs){
    return iIdxBizXnzsService.save(idxBizXnzs);
    }

    /**
    * 根据id删除
    * @param id
    * @return
    */
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(HttpServletRequest request, @PathVariable Long id){
    return iIdxBizXnzsService.removeById(id);
    }




    /**
    * 修改
    * @return
    */
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public boolean updateByIdIdxBizXnzs(HttpServletRequest request, @RequestBody IdxBizXnzs idxBizXnzs){
    return iIdxBizXnzsService.updateById(idxBizXnzs);
    }



    /**
   * 根据id查询
   * @param id
   * @return
   */
   @RequestMapping(value = "/{id}", method = RequestMethod.GET)
   @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
   public IdxBizXnzs selectById(HttpServletRequest request, @PathVariable Long id){
      return iIdxBizXnzsService.getById(id);
   }



  /**
  * 列表分页查询
  * @return
  */
  @TycloudOperation(ApiLevel = UserType.AGENCY ,needAuth = false)
  @RequestMapping(value = "/list", method = RequestMethod.GET)
  @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
  public IPage<IdxBizXnzs> listPage(String pageNum,String pageSize,
    IdxBizXnzs idxBizXnzs){

    Page<IdxBizXnzs> pageBean;
    QueryWrapper<IdxBizXnzs> idxBizXnzsQueryWrapper = new QueryWrapper<>();
    Class<? extends IdxBizXnzs> aClass = idxBizXnzs.getClass();
    Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
        try {
            field.setAccessible(true);
            Object o = field.get(idxBizXnzs);
            if (o != null) {
                Class<?> type = field.getType();
                String name = NameUtils.camel2Underline(field.getName());
                if (type.equals(Integer.class)) {
                Integer fileValue = (Integer) field.get(idxBizXnzs);
                idxBizXnzsQueryWrapper.eq(name, fileValue);
                } else if (type.equals(Long.class)) {
                Long fileValue = (Long) field.get(idxBizXnzs);
                idxBizXnzsQueryWrapper.eq(name, fileValue);
                } else if (type.equals(String.class)) {
                String fileValue = (String) field.get(idxBizXnzs);
                idxBizXnzsQueryWrapper.eq(name, fileValue);
                } else {
                String fileValue = (String) field.get(idxBizXnzs);
                idxBizXnzsQueryWrapper.eq(name, fileValue);
            }
          }
        }catch (Exception e) {
        }
    });
    IPage<IdxBizXnzs> page;
    if (StringUtils.isBlank(pageNum)  ||StringUtils.isBlank(pageSize)) {
        pageBean = new Page<>(0, Long.MAX_VALUE);
    }else{
        pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
    }
    page = iIdxBizXnzsService.page(pageBean, idxBizXnzsQueryWrapper);
    return page;
  }


    /**
     * 查询
     * @param
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY ,needAuth = false)
    @RequestMapping(value = "/select", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "查询地市", notes = "查询地市")
    public ResponseModel<JSONObject> select(){
        return ResponseHelper.buildResponse(iIdxBizXnzsService.select());
    }

    /**
     * 查询政务大列
     * @author 王龙
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @RequestMapping(value = "/selectZwdl", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET",value = "查询政务大类", notes = "查询政务大类")
    public  ResponseModel<JSONObject> selectZwdl() {
            return ResponseHelper.buildResponse(iIdxBizXnzsService.selectZwdl());
    }

}




